/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.tenant.client.support.database.oracle;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.db.meta.Column;
import cn.hutool.db.meta.ColumnIndexInfo;
import cn.hutool.db.meta.IndexInfo;
import cn.hutool.db.meta.Table;
import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import com.elitescloud.boot.tenant.client.common.DataBaseExport;
import com.elitescloud.boot.tenant.client.support.database.AbstractExporter;
import com.elitescloud.boot.tenant.client.support.database.TableCreate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class OracleExporter
extends AbstractExporter {
    private static final Logger LOGGER = CloudtBootLoggerFactory.TENANT_TRANSACTION.getLogger(OracleExporter.class);
    private Map<String, String> existsIndexNames = new HashMap<String, String>();
    private Map<String, String> existsPrimaryNames = new HashMap<String, String>();
    private int maxIndexLength = 30;

    public OracleExporter(DataBaseExport dataBaseExport) {
        super(dataBaseExport);
    }

    @Override
    protected void beforeExport() {
    }

    @Override
    protected String generateTableDdl(Table table) {
        String tableName = table.getTableName();
        switch (this.dataBaseExport.getTableCreate()) {
            case CREATE: {
                return this.generateTableDirectly(table);
            }
            case DROP_BEFORE_CREATE: {
                return String.format("DECLARE\n  table_num int(8);\n  BEGIN\n    SELECT COUNT(*) INTO table_num FROM all_tables WHERE table_name = '%s' AND owner = (SELECT sys_context('userenv', 'current_schema' ) FROM dual);\n    IF(table_num = 1) THEN\n       EXECUTE IMMEDIATE 'DROP TABLE \"%s\"';\n    END IF;\n%s  END;", tableName, tableName, this.generateTableDynamic(table));
            }
            case CREATE_IF_NO_EXISTS: {
                return String.format("DECLARE\n  table_num int(8);\n  BEGIN\n    SELECT COUNT(*) INTO table_num FROM all_tables WHERE table_name = '%s' AND owner = (SELECT sys_context('userenv', 'current_schema' ) FROM dual);\n    IF(table_num = 0) THEN\n%s    END IF;\n  END;", tableName, this.generateTableDynamic(table));
            }
        }
        throw new RuntimeException("\u672a\u77e5\u521b\u5efa\u7b56\u7565");
    }

    private String generateTableDirectly(Table table) {
        String tableName = this.sensitiveName(table.getTableName(), this.dataBaseExport.isTableNameSensitive());
        StringBuilder result = new StringBuilder();
        result.append(String.format("CREATE TABLE %s ( %n", tableName));
        String columns = this.generateColumns(table);
        result.append(columns);
        result.append("); \n");
        result.append(String.format("COMMENT ON TABLE %s IS '%s'; %n", tableName, CharSequenceUtil.blankToDefault((CharSequence)table.getComment(), (String)table.getTableName())));
        result.append(this.generateColumnComment(table));
        result.append(this.generateKeys(table));
        return result.toString();
    }

    private String generateTableDynamic(Table table) {
        String tableName = this.sensitiveName(table.getTableName(), this.dataBaseExport.isTableNameSensitive());
        String columnDdl = this.generateColumns(table);
        StringBuilder result = new StringBuilder();
        result.append(String.format("\tEXECUTE IMMEDIATE 'CREATE TABLE %s ( ' ||\n%s\t\t\t\t\t\t')';\n", tableName, columnDdl));
        result.append("\tEXECUTE IMMEDIATE '").append(String.format("COMMENT ON TABLE %s IS ''%s'' ", tableName, CharSequenceUtil.blankToDefault((CharSequence)table.getComment(), (String)table.getTableName()))).append("'; \n");
        result.append(this.generateColumnComment(table));
        result.append(this.generateKeys(table));
        return result.toString();
    }

    private String sensitiveName(String name, boolean sensitive) {
        return sensitive ? name : "\"" + name + "\"";
    }

    private String generateColumns(Table table) {
        ArrayList<String> ddlList = new ArrayList<String>();
        for (Column column : table.getColumns()) {
            StringBuilder result = new StringBuilder();
            result.append(String.format("%s    ", this.sensitiveName(column.getName(), this.dataBaseExport.isColumnNameSensitive())));
            result.append(this.normalizeColumnType(column).toUpperCase());
            result.append(this.normalizeNullable(column));
            if (column.isAutoIncrement()) {
                // empty if block
            }
            ddlList.add(result.toString());
        }
        if (!this.dynamic()) {
            return String.join((CharSequence)", \n", ddlList) + "\n";
        }
        return "\t\t\t\t\t\t\t'" + String.join((CharSequence)",' || \n \t\t\t\t\t\t\t'", ddlList) + "' || \n";
    }

    private String generateColumnComment(Table table) {
        String tableName = this.sensitiveName(table.getTableName(), this.dataBaseExport.isTableNameSensitive());
        StringBuilder result = new StringBuilder();
        boolean dynamic = this.dynamic();
        for (Column column : table.getColumns()) {
            String comment = this.normalizeComment(CharSequenceUtil.blankToDefault((CharSequence)column.getComment(), (String)column.getName()));
            if (dynamic) {
                result.append("\tEXECUTE IMMEDIATE '").append(String.format("COMMENT ON COLUMN %s.%s IS ''%s'' ", tableName, this.sensitiveName(column.getName(), this.dataBaseExport.isColumnNameSensitive()), comment)).append("';\n");
                continue;
            }
            result.append(String.format("COMMENT ON COLUMN %s.%s IS '%s';", tableName, this.sensitiveName(column.getName(), this.dataBaseExport.isColumnNameSensitive()), comment)).append("\n");
        }
        return result.toString();
    }

    private String normalizeColumnType(Column column) {
        switch (column.getType()) {
            case -7: {
                return "number(1, 0) ";
            }
            case -6: {
                return "number(3, 0) ";
            }
            case 5: {
                return "number(5, 0) ";
            }
            case 4: {
                return "number(10, 0) ";
            }
            case -5: {
                return "number(19, 0) ";
            }
            case 6: {
                return String.format("float(%s, %s) ", column.getSize(), column.getDigit());
            }
            case 7: {
                return "float(24) ";
            }
            case 2: 
            case 3: 
            case 8: {
                return String.format("number(%s, %s) ", column.getSize(), column.getDigit());
            }
            case -15: 
            case 1: {
                return String.format("char(%s) ", column.getSize());
            }
            case -9: 
            case 12: {
                if (column.getSize() > 2000L) {
                    return "clob ";
                }
                return String.format("nvarchar2(%s) ", column.getSize());
            }
            case -1: 
            case 2005: 
            case 2011: {
                return "clob ";
            }
            case 91: 
            case 92: 
            case 93: {
                return "date ";
            }
            case -3: 
            case -2: {
                return "raw ";
            }
            case -4: 
            case 2004: {
                return "blob ";
            }
        }
        return "nvarchar2 ";
    }

    private String normalizeNullable(Column column) {
        if (column.isNullable()) {
            Set<Integer> dateTypeValue = Set.of(Integer.valueOf(93), Integer.valueOf(91), Integer.valueOf(92), Integer.valueOf(2013), Integer.valueOf(2014));
            if (StringUtils.hasText((String)column.getColumnDef())) {
                if (dateTypeValue.contains(column.getType())) {
                    return "DEFAULT sysdate ";
                }
                return String.format(this.dynamic() ? "DEFAULT ''%s'' " : "DEFAULT '%s' ", column.getColumnDef());
            }
            return "";
        }
        return "NOT NULL ";
    }

    private String normalizeComment(String comment) {
        if (!StringUtils.hasText((String)comment)) {
            return null;
        }
        while (comment.startsWith("'")) {
            comment = comment.substring(1);
        }
        while (comment.endsWith("'")) {
            comment = comment.substring(0, comment.length() - 1);
        }
        return comment;
    }

    private String generateKeys(Table table) {
        List<IndexInfo> indexInfoList = table.getIndexInfoList();
        if (CollectionUtils.isEmpty((Collection)indexInfoList)) {
            return "";
        }
        indexInfoList = this.distinctIndexInfo(table);
        boolean dynamic = this.dynamic();
        StringBuilder result = new StringBuilder();
        for (IndexInfo indexInfo : indexInfoList) {
            String indexName;
            if (indexInfo.getIndexName().equals("PRIMARY")) {
                indexName = this.generateIndexName(indexInfo, true);
                if (dynamic) {
                    result.append("\tEXECUTE IMMEDIATE '").append(String.format("ALTER TABLE \"%s\" ADD CONSTRAINT \"%s\" PRIMARY KEY (%s)", table.getTableName(), indexName, this.generateKeyColumnNames(indexInfo.getColumnIndexInfoList()))).append(" '; \n");
                    continue;
                }
                result.append(String.format("ALTER TABLE \"%s\" ADD CONSTRAINT \"%s\" PRIMARY KEY (%s);%n", table.getTableName(), indexName, this.generateKeyColumnNames(indexInfo.getColumnIndexInfoList())));
                continue;
            }
            indexName = this.generateIndexName(indexInfo, false);
            if (dynamic) {
                result.append("\tEXECUTE IMMEDIATE '").append(indexInfo.isNonUnique() ? "CREATE INDEX " : "CREATE UNIQUE INDEX ").append(String.format("\"%s\" on \"%s\" (%s)", indexName, table.getTableName(), this.generateKeyColumns(indexInfo.getColumnIndexInfoList()))).append(" '; \n");
                continue;
            }
            result.append(indexInfo.isNonUnique() ? "CREATE INDEX " : "CREATE UNIQUE INDEX ").append(String.format("\"%s\" on \"%s\" (%s);%n", indexName, table.getTableName(), this.generateKeyColumns(indexInfo.getColumnIndexInfoList())));
        }
        return result.toString();
    }

    private String generateIndexName(IndexInfo indexInfo, boolean primaryKey) {
        String existsIndexTableName;
        Object indexName;
        Map<String, String> indexMapCache = primaryKey ? this.existsPrimaryNames : this.existsIndexNames;
        Object object = indexName = primaryKey ? "pk_" + indexInfo.getTableName() : indexInfo.getIndexName();
        if (((String)indexName).length() > this.maxIndexLength) {
            indexName = ((String)indexName).substring(0, this.maxIndexLength);
        }
        if (!StringUtils.hasText((String)(existsIndexTableName = indexMapCache.get(indexName)))) {
            indexMapCache.put((String)indexName, indexInfo.getTableName());
            return indexName;
        }
        indexName = this.normalizeIndexName(indexInfo);
        if (((String)indexName).length() <= this.maxIndexLength) {
            return indexName;
        }
        indexName = ((String)indexName).substring(0, this.maxIndexLength);
        int index = 1;
        int value = 0;
        indexName = ((String)indexName).substring(0, ((String)indexName).length() - index);
        String tempIndexName = (String)indexName + value;
        while (indexMapCache.containsKey(tempIndexName)) {
            tempIndexName = (String)indexName + ++value;
            if (!("" + value).endsWith("9")) continue;
            indexName = ((String)indexName).substring(0, ((String)indexName).length() - ++index);
        }
        indexMapCache.put(tempIndexName, indexInfo.getTableName());
        return tempIndexName;
    }

    private String generateKeyColumnNames(List<ColumnIndexInfo> indexInfoList) {
        return indexInfoList.stream().map(t -> String.format("\"%s\"", t.getColumnName())).collect(Collectors.joining(", "));
    }

    private String generateKeyColumns(List<ColumnIndexInfo> indexInfoList) {
        return indexInfoList.stream().map(t -> String.format("\"%s\" %s", t.getColumnName(), CharSequenceUtil.equals((CharSequence)t.getAscOrDesc(), (CharSequence)"A") ? "ASC" : "DESC")).collect(Collectors.joining(", "));
    }

    private boolean dynamic() {
        return this.dataBaseExport.getTableCreate() != TableCreate.CREATE;
    }
}

