/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.tenant.client;

import com.elitescloud.boot.condition.ConditionalOnTenant;
import com.elitescloud.boot.tenant.client.common.AbstractTenantDatasourceProvider;
import com.elitescloud.cloudt.common.constant.TenantIsolateStrategy;
import com.elitescloud.cloudt.context.util.database.DatasourceLoadUtil;
import com.zaxxer.hikari.HikariDataSource;
import javax.sql.DataSource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.event.ApplicationContextInitializedEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.SmartApplicationListener;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.lang.NonNull;
import org.springframework.orm.jpa.vendor.Database;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@ConditionalOnTenant(isolateStrategy={TenantIsolateStrategy.SCHEMA})
class CloudtTenantDataSourceListener
implements SmartApplicationListener,
InitializingBean {
    CloudtTenantDataSourceListener() {
    }

    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        return eventType.isAssignableFrom(ApplicationContextInitializedEvent.class);
    }

    public void onApplicationEvent(@NonNull ApplicationEvent event) {
        if (event instanceof ApplicationContextInitializedEvent) {
            ConfigurableEnvironment env = ((ApplicationContextInitializedEvent)event).getApplicationContext().getEnvironment();
            TenantIsolateStrategy strategy = this.loadingDatabaseSeparate((Environment)env);
            if (strategy == null || strategy == TenantIsolateStrategy.NONE || strategy == TenantIsolateStrategy.FIELD) {
                return;
            }
            DataSource dataSource = this.loadingDataSource((Environment)env);
            this.loadingDefaultSchema((Environment)env);
            this.loadingDatabase((Environment)env, dataSource);
        }
    }

    public void afterPropertiesSet() throws Exception {
        Assert.hasText((String)AbstractTenantDatasourceProvider.getDefaultSchema(), (String)"\u9ed8\u8ba4\u79df\u6237schema\u4e3a\u7a7a");
        Assert.notNull((Object)AbstractTenantDatasourceProvider.getDefaultDataSource(), (String)"\u9ed8\u8ba4\u6570\u636e\u6e90\u4e3a\u7a7a");
    }

    private TenantIsolateStrategy loadingDatabaseSeparate(Environment env) {
        String strategy = env.getProperty("elitesland.tenant.client.isolate-strategy");
        TenantIsolateStrategy isolateStrategy = TenantIsolateStrategy.parse((String)strategy);
        AbstractTenantDatasourceProvider.setIsolateStrategy(isolateStrategy);
        return isolateStrategy;
    }

    private Database loadingDatabase(Environment env, DataSource dataSource) {
        Database database = null;
        if (dataSource instanceof HikariDataSource && (database = AbstractTenantDatasourceProvider.getDatabaseTypeByUrl(((HikariDataSource)dataSource).getJdbcUrl())) != null) {
            AbstractTenantDatasourceProvider.setDatabaseType(database);
            return database;
        }
        String dbTypeStr = env.getProperty("spring.jpa.database");
        if (StringUtils.hasText((String)dbTypeStr)) {
            try {
                database = Database.valueOf((String)dbTypeStr.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            if (database != null) {
                AbstractTenantDatasourceProvider.setDatabaseType(database);
                return database;
            }
        }
        return database;
    }

    private String loadingDefaultSchema(Environment env) {
        String schema = env.getProperty("elitesland.tenant.client.default-schema");
        if (StringUtils.hasText((String)schema)) {
            AbstractTenantDatasourceProvider.setDefaultSchema(schema);
        }
        return schema;
    }

    private DataSource loadingDataSource(Environment env) {
        DataSource dataSource = DatasourceLoadUtil.loadForHikari((Environment)env);
        AbstractTenantDatasourceProvider.setDefaultDataSource(dataSource);
        return dataSource;
    }
}

