package com.elitescloud.boot.threadpool.support;

import com.dtp.core.support.wrapper.TaskWrapper;

/**
 * 任务包装器.
 *
 * @author Kaiser（wang shao）
 * @date 2023/4/27
 */
public class CloudtCoreTaskWrapper implements TaskWrapper {

    @Override
    public String name() {
        return "cloudt-core";
    }

    @Override
    public Runnable wrap(Runnable runnable) {
        var contextTransferDelegate = ContextTransferDelegate.getInstance();
        // 先获取上下文信息
        contextTransferDelegate.getContext();

        return () -> {
            // 设置上下文信息
            contextTransferDelegate.setContext();

            try {
                runnable.run();
            } finally {
                // 清除上下文信息
                contextTransferDelegate.clearContext();
            }
        };
    }
}
