/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.threadpool.support;

import cn.hutool.core.text.CharSequenceUtil;
import com.dtp.common.config.DtpProperties;
import com.dtp.common.config.ThreadPoolProperties;
import com.dtp.core.DtpRegistry;
import com.dtp.core.thread.DtpExecutor;
import com.elitescloud.boot.threadpool.common.ThreadPoolHolder;
import java.util.Collection;
import java.util.List;
import org.springframework.lang.NonNull;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.util.CollectionUtils;

public class CustomTaskExecutor
extends ThreadPoolTaskExecutor {
    private static final long serialVersionUID = -669239293574082521L;
    public static final String CLOUDT_DTP_DEFAULT = "cloudT-dtp-default";
    public static final String CLOUDT_TP = "cloudT-tp-";
    private DtpExecutor dtpExecutor;

    public CustomTaskExecutor(DtpProperties dtpProperties) {
        this.buildDtpExecutor(dtpProperties);
    }

    public void execute(@NonNull Runnable task) {
        if (this.dtpExecutor == null) {
            this.dtpExecutor = DtpRegistry.getDtpExecutor((String)CLOUDT_DTP_DEFAULT);
        }
        this.dtpExecutor.execute(task);
    }

    private void buildDtpExecutor(DtpProperties dtpProperties) {
        List executorsConfigs = dtpProperties.getExecutors();
        if (dtpProperties.isEnabled() && !CollectionUtils.isEmpty((Collection)executorsConfigs)) {
            for (ThreadPoolProperties executorsConfig : executorsConfigs) {
                if (!CharSequenceUtil.equals((CharSequence)executorsConfig.getThreadPoolName(), (CharSequence)CLOUDT_DTP_DEFAULT)) continue;
                return;
            }
        }
        ThreadPoolHolder.createThreadPool(CLOUDT_DTP_DEFAULT, CLOUDT_TP, 8, 17);
    }
}

