/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.threadpool.support;

import cn.hutool.core.text.CharSequenceUtil;
import com.dtp.common.config.DtpProperties;
import com.dtp.common.config.ThreadPoolProperties;
import com.dtp.core.DtpRegistry;
import com.dtp.core.thread.DtpExecutor;
import com.elitescloud.boot.threadpool.common.ThreadPoolHolder;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.util.CollectionUtils;

public class CustomTaskExecutor
extends ThreadPoolTaskExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(CustomTaskExecutor.class);
    private static final long serialVersionUID = -669239293574082521L;
    public static final String CLOUDT_DTP_DEFAULT = "cloudT-dtp-default";
    public static final String CLOUDT_TP = "cloudT-tp-";
    private static volatile DtpExecutor dtpExecutor;

    public CustomTaskExecutor(DtpProperties dtpProperties) {
        this.buildDtpExecutor(dtpProperties);
    }

    public void execute(@NonNull Runnable task) {
        if (dtpExecutor == null) {
            dtpExecutor = DtpRegistry.getDtpExecutor((String)CLOUDT_DTP_DEFAULT);
        }
        dtpExecutor.execute(task);
    }

    @NonNull
    protected ExecutorService initializeExecutor(@NonNull ThreadFactory threadFactory, @NonNull RejectedExecutionHandler rejectedExecutionHandler) {
        if (dtpExecutor == null) {
            dtpExecutor = DtpRegistry.listAllDtpNames().contains(CLOUDT_DTP_DEFAULT) ? DtpRegistry.getDtpExecutor((String)CLOUDT_DTP_DEFAULT) : this.createDefault(8, 17);
        }
        return dtpExecutor;
    }

    public ThreadPoolExecutor getThreadPoolExecutor() throws IllegalStateException {
        if (dtpExecutor == null) {
            dtpExecutor = DtpRegistry.getDtpExecutor((String)CLOUDT_DTP_DEFAULT);
        }
        return dtpExecutor;
    }

    private void buildDtpExecutor(DtpProperties dtpProperties) {
        List executorsConfigs = dtpProperties.getExecutors();
        if (dtpProperties.isEnabled() && !CollectionUtils.isEmpty((Collection)executorsConfigs)) {
            for (ThreadPoolProperties executorsConfig : executorsConfigs) {
                if (!CharSequenceUtil.equals((CharSequence)executorsConfig.getThreadPoolName(), (CharSequence)CLOUDT_DTP_DEFAULT)) continue;
                LOG.info("ThreadPool Config will use config center");
                this.createDefault(executorsConfig.getCorePoolSize(), executorsConfig.getMaximumPoolSize());
                return;
            }
        }
    }

    private DtpExecutor createDefault(int coreSize, int maxSize) {
        if (dtpExecutor != null) {
            return dtpExecutor;
        }
        LOG.info("ThreadPool Config will create default manually\uff1a{}, {}", (Object)coreSize, (Object)maxSize);
        dtpExecutor = (DtpExecutor)ThreadPoolHolder.createThreadPool(CLOUDT_DTP_DEFAULT, CLOUDT_TP, coreSize, maxSize);
        return dtpExecutor;
    }
}

