package com.elitescloud.boot.threadpool.support;

import com.dtp.core.support.wrapper.TaskWrapper;
import org.apache.skywalking.apm.toolkit.trace.RunnableWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 任务包装器.
 *
 * @author Kaiser（wang shao）
 * @date 2023/4/27
 */
public class CloudtCoreTaskWrapper implements TaskWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(CloudtCoreTaskWrapper.class);

    @Override
    public String name() {
        return "cloudt-core";
    }

    @Override
    public Runnable wrap(Runnable runnable) {
        var contextTransferDelegate = ContextTransferDelegate.getInstance();
        // 先获取上下文信息
        contextTransferDelegate.getContext();

        return RunnableWrapper.of(() -> {
            // 设置上下文信息
            contextTransferDelegate.setContext();

            try {
                runnable.run();
            } catch (Throwable throwable) {
                LOG.error("异步任务异常：", throwable);
                throw throwable;
            } finally {
                // 清除上下文信息
                contextTransferDelegate.clearContext();
            }
        });
    }
}
