package com.elitescloud.boot.threadpool;

import com.dtp.common.config.DtpProperties;
import com.elitescloud.boot.threadpool.common.ThreadPoolHolder;
import com.elitescloud.boot.threadpool.support.ContextTransferDelegate;
import com.elitescloud.boot.threadpool.support.CustomTaskExecutor;
import org.springframework.beans.BeansException;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.task.TaskExecutionAutoConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.lang.NonNull;
import org.springframework.scheduling.annotation.AsyncAnnotationBeanPostProcessor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

import java.util.concurrent.ThreadPoolExecutor;

/**
 * 线程池相关配置.
 *
 * @author Kaiser（wang shao）
 * @date 2022/2/21
 */
@Configuration(proxyBeanMethods = false)
@AutoConfigureBefore(TaskExecutionAutoConfiguration.class)
public class ThreadPoolAutoConfiguration implements ApplicationContextAware, ApplicationRunner {
    public static final String BEAN_NAME = "cloudt_taskExecutor";

    private final DtpProperties dtpProperties;

    public ThreadPoolAutoConfiguration(DtpProperties dtpProperties) {
        this.dtpProperties = dtpProperties;
    }

    @Bean({TaskExecutionAutoConfiguration.APPLICATION_TASK_EXECUTOR_BEAN_NAME, AsyncAnnotationBeanPostProcessor.DEFAULT_TASK_EXECUTOR_BEAN_NAME, BEAN_NAME})
    @Primary
    public ThreadPoolTaskExecutor taskExecutor() {
        return new CustomTaskExecutor(dtpProperties);
    }

    @Bean
    public ThreadPoolExecutor cloudtDefaultDtpExecutor() {
        return ThreadPoolHolder.createThreadPool(ThreadPoolHolder.THREAD_POOL_NAME, CustomTaskExecutor.CLOUDT_TP, 8, 64);
    }

    @Override
    public void setApplicationContext(@NonNull ApplicationContext applicationContext) throws BeansException {
        ContextTransferDelegate.setApplicationContext(applicationContext);
    }

    @Override
    public void run(ApplicationArguments args) throws Exception {
        ContextTransferDelegate.refreshContextTransfer();
    }
}
