package com.elitescloud.boot.threadpool.support;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;

import java.util.concurrent.ThreadFactory;

/**
 * 自定义线程工厂.
 *
 * @author Kaiser（wang shao）
 * @date 2023/6/12
 */
public class CustomThreadFactory implements ThreadFactory {

    private Thread.UncaughtExceptionHandler exceptionHandler = new CustomUncaughtExceptionHandler();

    @Override
    public Thread newThread(@NonNull Runnable r) {
        var thread = new Thread(r);
        thread.setUncaughtExceptionHandler(exceptionHandler);
        return thread;
    }

    public void setExceptionHandler(Thread.UncaughtExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    private static class CustomUncaughtExceptionHandler implements Thread.UncaughtExceptionHandler {
        private static final Logger LOG = LoggerFactory.getLogger(CustomUncaughtExceptionHandler.class);
        @Override
        public void uncaughtException(Thread t, Throwable e) {
            LOG.error("异步线程未处理的异常：", e);
        }
    }
}
