/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.threadpool.support;

import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;

public class CustomThreadFactory
implements ThreadFactory {
    private Thread.UncaughtExceptionHandler exceptionHandler = new CustomUncaughtExceptionHandler();

    @Override
    public Thread newThread(@NonNull Runnable r) {
        Thread thread = new Thread(r);
        thread.setUncaughtExceptionHandler(this.exceptionHandler);
        return thread;
    }

    public void setExceptionHandler(Thread.UncaughtExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    private static class CustomUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private static final Logger LOG = LoggerFactory.getLogger(CustomUncaughtExceptionHandler.class);

        private CustomUncaughtExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            LOG.error("\u5f02\u6b65\u7ebf\u7a0b\u672a\u5904\u7406\u7684\u5f02\u5e38\uff1a", e);
        }
    }
}

