# 动态线程池使用说明

> 目前动态线程池管理是基于第三方框架 [DynamicTp](https://dynamictp.cn/) 实现的，支持动态修改配置、线程池信息监控和通知告警。

### 应用

###### （1）使用默认线程池

注入TaskExecutor（bean名称taskExecutor）即可，如下所示：

```
@Autowired
@Qualifier(ThreadPoolAutoConfiguration.BEAN_NAME)
private TaskExecutor taskExecutor;
```

###### （2）自定义创建线程池

可使用`threadpool.com.elitescloud.cloudt.context.ThreadPoolHolder.createThreadPool()`相关方法快速创建线程池。

### 动态配置

DynamicTp目前支持nacos和Apollo配置中心的动态配置，且内部提供了SPI接口可扩展支持其它类型的实现。

<mark>**注意：Spring.dynamic.tp.enabled配置表示是否使用动态线程池配置管理，该值的改变需要重启服务方能生效。**</mark>

### 信息监控

DynamicTp目前支持log输出到磁盘、MicroMeter采集和Endpoint三种方式获取监控信息，使用Endpoint是只要项目启用了springboot的endpoint就支持，可通过http://127.0.0.1:9001/actuator/dynamic-tp 访问。亦提供了SPI接口扩展其他实现。

### 通知告警

告警方式目前已提供了钉钉、企业微信的方式，若需要自定义，则可通过其提供的SPI接口扩展实现，目前通知告警类型如下：

- 线程池参数变更通知；

- 阻塞队列容量达到设置阈值告警；

- 线程池活性达到设置阈值告警；

- 触发拒绝策略告警

线程池、信息监控和通知告警均支持在配置中心配置。
