package com.elitescloud.boot.threadpool;

import com.elitescloud.boot.constant.BeanNameConstant;
import com.elitescloud.boot.threadpool.common.ThreadPoolHolder;
import com.elitescloud.boot.threadpool.config.ThreadPoolProperties;
import com.elitescloud.boot.threadpool.support.ContextTransferDelegate;
import com.elitescloud.boot.threadpool.support.CustomTaskExecutor;
import com.elitescloud.boot.threadpool.support.ThreadPoolEndpoint;
import org.dromara.dynamictp.adapter.rocketmq.RocketMqDtpAdapter;
import org.dromara.dynamictp.common.properties.DtpProperties;
import org.dromara.dynamictp.core.spring.EnableDynamicTp;
import org.springframework.beans.BeansException;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.task.TaskExecutionAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.lang.NonNull;
import org.springframework.scheduling.annotation.AsyncAnnotationBeanPostProcessor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

import java.util.concurrent.ThreadPoolExecutor;

/**
 * 线程池相关配置.
 *
 * @author Kaiser（wang shao）
 * @date 2022/2/21
 */
@EnableDynamicTp
@AutoConfigureBefore(TaskExecutionAutoConfiguration.class)
@Import({ThreadPoolAutoConfiguration.RocketMqAdapter.class})
@EnableConfigurationProperties({ThreadPoolProperties.class})
public class ThreadPoolAutoConfiguration implements ApplicationContextAware, ApplicationRunner {
    public static final String BEAN_NAME = BeanNameConstant.TASK_EXECUTOR;

    private final DtpProperties dtpProperties;

    public ThreadPoolAutoConfiguration(DtpProperties dtpProperties) {
        this.dtpProperties = dtpProperties;
    }

    @Bean({TaskExecutionAutoConfiguration.APPLICATION_TASK_EXECUTOR_BEAN_NAME, AsyncAnnotationBeanPostProcessor.DEFAULT_TASK_EXECUTOR_BEAN_NAME, BEAN_NAME})
    @Primary
    public ThreadPoolTaskExecutor taskExecutor() {
        return new CustomTaskExecutor(dtpProperties);
    }

    @Bean({BeanNameConstant.THREAD_POOL_EXECUTOR})
    public ThreadPoolExecutor cloudtDefaultDtpExecutor() {
        return ThreadPoolHolder.createThreadPool(ThreadPoolHolder.THREAD_POOL_NAME, CustomTaskExecutor.CLOUDT_TP, 8, 64);
    }

    @Bean
    @ConditionalOnAvailableEndpoint
    public ThreadPoolEndpoint threadPoolEndpoint() {
        return new ThreadPoolEndpoint();
    }

    @Override
    public void setApplicationContext(@NonNull ApplicationContext applicationContext) throws BeansException {
        ContextTransferDelegate.setApplicationContext(applicationContext);
    }

    @Override
    public void run(ApplicationArguments args) throws Exception {
        ContextTransferDelegate.refreshContextTransfer();
    }

    @ConditionalOnClass(
            name = {"org.apache.rocketmq.client.consumer.DefaultMQPushConsumer"}
    )
    @ConditionalOnProperty(prefix = "elitesland.mq", name = "enabled", havingValue = "false")
    static class RocketMqAdapter {

        @Bean
        public RocketMqDtpAdapter rocketMqDtpAdapterCloudt() {
            return new RocketMqDtpAdapter() {
                @Override
                protected void initialize() {
                }
            };
        }
    }
}
