package com.elitescloud.boot.threadpool.config;

import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * 线程池配置.
 *
 * @author Kaiser（wang shao）
 * @date 2024/9/3
 */
@ConfigurationProperties(prefix = ThreadPoolProperties.CONFIG_PREFIX)
public class ThreadPoolProperties {
    public static final String CONFIG_PREFIX = "elitesland.thread-pool";

    /**
     * 是否启用调用栈跟踪
     */
    private Boolean enableStackTrace = true;

    public Boolean getEnableStackTrace() {
        return enableStackTrace;
    }

    public void setEnableStackTrace(Boolean enableStackTrace) {
        this.enableStackTrace = enableStackTrace;
    }
}
