/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.threadpool.support;

import com.elitescloud.boot.CloudtSpringContextHolder;
import com.elitescloud.boot.threadpool.config.ThreadPoolProperties;
import com.elitescloud.boot.threadpool.support.ContextTransferDelegate;
import org.apache.skywalking.apm.toolkit.trace.RunnableWrapper;
import org.dromara.dynamictp.core.support.task.wrapper.TaskWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudtCoreTaskWrapper
implements TaskWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(CloudtCoreTaskWrapper.class);
    private ThreadPoolProperties threadPoolProperties;

    public String name() {
        return "cloudt-core";
    }

    public Runnable wrap(Runnable runnable) {
        StackTraceElement[] stackTraceElements = null;
        try {
            if (this.threadPoolProperties == null) {
                this.threadPoolProperties = (ThreadPoolProperties)CloudtSpringContextHolder.getApplicationContext().getBeanProvider(ThreadPoolProperties.class).getIfAvailable();
            }
            boolean supportStackStrace = this.threadPoolProperties != null && Boolean.TRUE.equals(this.threadPoolProperties.getEnableStackTrace());
            stackTraceElements = supportStackStrace ? Thread.currentThread().getStackTrace() : new StackTraceElement[]{};
        }
        catch (Exception e) {
            LOG.error("\u83b7\u53d6\u8c03\u7528\u8005\u5806\u6808\u4fe1\u606f\u5f02\u5e38\uff1a", (Throwable)e);
        }
        ContextTransferDelegate contextTransferDelegate = ContextTransferDelegate.getInstance();
        contextTransferDelegate.getContext();
        return new CloudtRunnable((Runnable)RunnableWrapper.of((Runnable)runnable), stackTraceElements, contextTransferDelegate);
    }

    static class CloudtRunnable
    implements Runnable {
        private final Runnable original;
        private final StackTraceElement[] stackTraceElements;
        private final ContextTransferDelegate contextTransferDelegate;

        public CloudtRunnable(Runnable original, StackTraceElement[] stackTraceElements, ContextTransferDelegate contextTransferDelegate) {
            this.original = original;
            this.stackTraceElements = stackTraceElements;
            this.contextTransferDelegate = contextTransferDelegate;
        }

        @Override
        public void run() {
            this.contextTransferDelegate.setContext();
            try {
                this.original.run();
            }
            catch (Throwable throwable) {
                LOG.error("\u5f02\u6b65\u4efb\u52a1\u5f02\u5e38\uff1a", throwable);
                throw throwable;
            }
            finally {
                this.contextTransferDelegate.clearContext();
            }
        }

        public Runnable getOriginal() {
            return this.original;
        }

        public StackTraceElement[] getStackTraceElements() {
            return this.stackTraceElements;
        }
    }
}

