/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.threadpool.support;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import com.elitescloud.boot.threadpool.common.ThreadPoolHolder;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import org.dromara.dynamictp.common.entity.DtpExecutorProps;
import org.dromara.dynamictp.common.properties.DtpProperties;
import org.dromara.dynamictp.core.DtpRegistry;
import org.dromara.dynamictp.core.executor.DtpExecutor;
import org.slf4j.Logger;
import org.springframework.lang.NonNull;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.util.CollectionUtils;

public class CustomTaskExecutor
extends ThreadPoolTaskExecutor {
    private static final Logger LOG = CloudtBootLoggerFactory.THREAD_POOL.getLogger(CustomTaskExecutor.class);
    private static final long serialVersionUID = -669239293574082521L;
    public static final String CLOUDT_DTP_DEFAULT = "cloudT-dtp-default";
    public static final String CLOUDT_TP = "cloudT-tp-";
    private static volatile DtpExecutor dtpExecutor;

    public CustomTaskExecutor(DtpProperties dtpProperties) {
        this.buildDtpExecutor(dtpProperties);
    }

    public void execute(@NonNull Runnable task) {
        if (dtpExecutor == null) {
            dtpExecutor = DtpRegistry.getDtpExecutor((String)CLOUDT_DTP_DEFAULT);
        }
        dtpExecutor.execute(task);
    }

    @NonNull
    protected ExecutorService initializeExecutor(@NonNull ThreadFactory threadFactory, @NonNull RejectedExecutionHandler rejectedExecutionHandler) {
        if (dtpExecutor == null) {
            dtpExecutor = DtpRegistry.getAllExecutorNames().contains(CLOUDT_DTP_DEFAULT) ? DtpRegistry.getDtpExecutor((String)CLOUDT_DTP_DEFAULT) : this.createDefault(8, 17, 256);
        }
        return dtpExecutor;
    }

    public ThreadPoolExecutor getThreadPoolExecutor() throws IllegalStateException {
        if (dtpExecutor == null) {
            dtpExecutor = DtpRegistry.getDtpExecutor((String)CLOUDT_DTP_DEFAULT);
        }
        return dtpExecutor;
    }

    private void buildDtpExecutor(DtpProperties dtpProperties) {
        List executorsConfigs = dtpProperties.getExecutors();
        if (dtpProperties.isEnabled() && !CollectionUtils.isEmpty((Collection)executorsConfigs)) {
            for (DtpExecutorProps executorsConfig : executorsConfigs) {
                if (!CharSequenceUtil.equals((CharSequence)executorsConfig.getThreadPoolName(), (CharSequence)CLOUDT_DTP_DEFAULT)) continue;
                LOG.info("ThreadPool Config will use config center");
                this.createDefault(executorsConfig.getCorePoolSize(), executorsConfig.getMaximumPoolSize(), executorsConfig.getQueueCapacity());
                return;
            }
        }
    }

    private DtpExecutor createDefault(int coreSize, int maxSize, int queueCapacity) {
        if (dtpExecutor != null) {
            return dtpExecutor;
        }
        LOG.info("ThreadPool Config will create default manually\uff1a{}, {}, {}", new Object[]{coreSize, maxSize, queueCapacity});
        dtpExecutor = (DtpExecutor)ThreadPoolHolder.createThreadPool(CLOUDT_DTP_DEFAULT, CLOUDT_TP, coreSize, maxSize, queueCapacity);
        return dtpExecutor;
    }
}

