/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.threadpool;

import com.elitescloud.boot.threadpool.common.ThreadPoolHolder;
import com.elitescloud.boot.threadpool.config.ThreadPoolProperties;
import com.elitescloud.boot.threadpool.support.ContextTransferDelegate;
import com.elitescloud.boot.threadpool.support.CustomTaskExecutor;
import com.elitescloud.boot.threadpool.support.ThreadPoolEndpoint;
import java.util.concurrent.ThreadPoolExecutor;
import org.dromara.dynamictp.adapter.rocketmq.RocketMqDtpAdapter;
import org.dromara.dynamictp.common.properties.DtpProperties;
import org.dromara.dynamictp.core.spring.EnableDynamicTp;
import org.springframework.beans.BeansException;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.task.TaskExecutionAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.lang.NonNull;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@EnableDynamicTp
@AutoConfigureBefore(value={TaskExecutionAutoConfiguration.class})
@Import(value={RocketMqAdapter.class})
@EnableConfigurationProperties(value={ThreadPoolProperties.class})
public class ThreadPoolAutoConfiguration
implements ApplicationContextAware,
ApplicationRunner {
    public static final String BEAN_NAME = "cloudt_taskExecutor";
    private final DtpProperties dtpProperties;

    public ThreadPoolAutoConfiguration(DtpProperties dtpProperties) {
        this.dtpProperties = dtpProperties;
    }

    @Bean(value={"applicationTaskExecutor", "taskExecutor", "cloudt_taskExecutor"})
    @Primary
    public ThreadPoolTaskExecutor taskExecutor() {
        return new CustomTaskExecutor(this.dtpProperties);
    }

    @Bean(value={"cloudt_threadPoolExecutor"})
    public ThreadPoolExecutor cloudtDefaultDtpExecutor() {
        return ThreadPoolHolder.createThreadPool("cloudT-dtp-common", "cloudT-tp-", 8, 64);
    }

    @Bean
    @ConditionalOnAvailableEndpoint
    public ThreadPoolEndpoint threadPoolEndpoint() {
        return new ThreadPoolEndpoint();
    }

    public void setApplicationContext(@NonNull ApplicationContext applicationContext) throws BeansException {
        ContextTransferDelegate.setApplicationContext(applicationContext);
    }

    public void run(ApplicationArguments args) throws Exception {
        ContextTransferDelegate.refreshContextTransfer();
    }

    @ConditionalOnClass(name={"org.apache.rocketmq.client.consumer.DefaultMQPushConsumer"})
    @ConditionalOnProperty(prefix="elitesland.mq", name={"enabled"}, havingValue="false")
    static class RocketMqAdapter {
        RocketMqAdapter() {
        }

        @Bean
        public RocketMqDtpAdapter rocketMqDtpAdapterCloudt() {
            return new RocketMqDtpAdapter(){

                protected void initialize() {
                }
            };
        }
    }
}

