package com.elitescloud.boot.web.config.filter;

import com.elitescloud.boot.web.config.WebProperties;
import com.elitescloud.boot.wrapper.CloudtRequestWrapper;
import com.elitescloud.cloudt.context.util.HttpServletUtil;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;

/**
 * 自定义request封装filter.
 *
 * @author Kaiser（wang shao）
 * @date 2022/8/21
 */
public class CloudtRequestWrapperFilter implements Filter {

    private final WebProperties.WrapRequest wrapRequest;

    public CloudtRequestWrapperFilter(WebProperties.WrapRequest wrapRequest) {
        this.wrapRequest = wrapRequest;
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof CloudtRequestWrapper || !(request instanceof HttpServletRequest)) {
            chain.doFilter(request, response);
            return;
        }

        // 判断对上传文件请求的支持
        if (!wrapRequest.getSupportMultipart() && HttpServletUtil.isMultipartContent(request)) {
            chain.doFilter(request, response);
            return;
        }

        chain.doFilter(new CloudtRequestWrapper((HttpServletRequest) request), response);
    }
}
