package com.elitescloud.boot.web.config;

import com.elitescloud.boot.web.config.filter.CloudtRequestWrapperFilter;
import com.elitescloud.boot.web.config.trace.ServletWebLogTraceHandler;
import lombok.extern.log4j.Log4j2;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.core.Ordered;

import java.util.List;

/**
 * servlet类型的web自定义配置.
 *
 * @author Kaiser（wang shao）
 * @date 2021/12/23
 */
@ConditionalOnWebApplication(type = ConditionalOnWebApplication.Type.SERVLET)
@Log4j2
public class CustomServletWebConfig extends AbstractCustomWebConfig {

    private final WebProperties webProperties;

    public CustomServletWebConfig(WebProperties webProperties) {
        this.webProperties = webProperties;
    }

    @Bean
    public FilterRegistrationBean<ServletWebLogTraceHandler> logMdcFilterFilterRegistrationBean() {
        log.info("add ServletWebLogTraceHandler");

        FilterRegistrationBean<ServletWebLogTraceHandler> registrationBean = new FilterRegistrationBean<>(new ServletWebLogTraceHandler(applicationName));

        registrationBean.setUrlPatterns(List.of("/*"));
        registrationBean.setOrder(Ordered.HIGHEST_PRECEDENCE);

        return registrationBean;
    }

    @Bean
    @ConditionalOnProperty(prefix = WebProperties.CONFIG_PREFIX + ".wrap-request", name = "enabled", havingValue = "true", matchIfMissing = true)
    public FilterRegistrationBean<CloudtRequestWrapperFilter> requestWrapperFilterFilterRegistrationBean() {
        FilterRegistrationBean<CloudtRequestWrapperFilter> registrationBean = new FilterRegistrationBean<>(
                new CloudtRequestWrapperFilter(webProperties.getWrapRequest())
        );
        registrationBean.setOrder(-1);
        registrationBean.addUrlPatterns("/*");

        return registrationBean;
    }
}
