package com.elitescloud.boot.web.formatter;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.stereotype.Component;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author : chen.niu
 * @description :
 * @date : 2023/9/20 16:36
 */
@Aspect
@Slf4j
public class BigDecimalFormatAspect {
    private static final Map<Class<?>, Field[]> classFieldsCache = new HashMap<>();

    private  final BigDecimalTypeConfig bigDecimalTypeConfig;

    public BigDecimalFormatAspect(BigDecimalTypeConfig bigDecimalTypeConfig) {
        this.bigDecimalTypeConfig = bigDecimalTypeConfig;
    }

    @Around("@within(org.springframework.web.bind.annotation.RestController) || @annotation(org.springframework.web.bind.annotation.ResponseBody)")
    public Object aroundControllerResponse(ProceedingJoinPoint joinPoint) throws Throwable {
        Object result = joinPoint.proceed();
        try {
            if (result != null) {
                if (result instanceof ApiResult) {
                    Object data = ((ApiResult) result).getData();
                    if (data != null) {
                        if (data instanceof PagingVO) {
                            getListFieldValue(((PagingVO) data).getRecords());
                        }
                        else if (data instanceof Collection) {
                            getListFieldValue((List) data);
                        } else {
                            getFieldValue(data);
                        }
                    }
                }
            }
        }catch (Exception e){
            log.error("BigDecimalFormatAspect 格式化异常："+e.getMessage());
            return result;
        }
        return result;
    }


    private  void getListFieldValue(List dataList) throws IllegalAccessException {
        if (dataList == null) {
            return;
        }
        for (Object od : dataList) {
            getFieldValue(od);
        }
    }


    private  void getFieldValue(Object result) throws IllegalAccessException {
        if (result == null) {
            return;
        }
        Class<?> resultClass = result.getClass();
        Field[] fields = classFieldsCache.computeIfAbsent(resultClass, cls -> resultClass.getDeclaredFields());
        for (Field field : fields) {
            if (field.isAnnotationPresent(BigDecimalFormat.class) && field.getType() == BigDecimal.class) {
                BigDecimalFormat annotation = field.getAnnotation(BigDecimalFormat.class);
                field.setAccessible(true);
                BigDecimal value = (BigDecimal) field.get(result);
                if (value != null) {
                    BigDecimal scaledValue = value;
                   if(annotation.bdType()!=null && !annotation.bdType().name().equals(BigDecimalType.CUSTOM.name())) {
                       if(annotation.bdType().equals(BigDecimalType.AMOUNT)){
                           scaledValue = value.setScale(bigDecimalTypeConfig.getAmountScale(),
                                   RoundingMode.valueOf(bigDecimalTypeConfig.getAmountRoundingMode()));
                       }
                       if(annotation.bdType().equals(BigDecimalType.PRICE)){
                           scaledValue = value.setScale(bigDecimalTypeConfig.getPriceScale(),
                                   RoundingMode.valueOf(bigDecimalTypeConfig.getPriceRoundingMode()));
                       }
                       if(annotation.bdType().equals(BigDecimalType.QUANTITY)){
                           scaledValue = value.setScale(bigDecimalTypeConfig.getQuantityScale(),
                                   RoundingMode.valueOf(bigDecimalTypeConfig.getQuantityRoundingMode()));
                       }
                   } else{
                        scaledValue = value.setScale(annotation.scale(), annotation.roundingMode());

                   }
                    field.set(result, scaledValue);
                }
            }
        }
    }

}
