package com.elitescloud.boot.web.common;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.crypto.digest.MD5;
import com.elitescloud.boot.wrapper.CloudtRequestWrapper;
import org.springframework.util.StringUtils;

import javax.servlet.http.HttpServletRequest;

/**
 * 请求头和请求体的key生成器.
 * <p>
 * 优先根据请求头，如果请求头不存在，再根据请求信息生成key
 *
 * @author Kaiser（wang shao）
 * @date 2024/2/2
 */
public class WebHeaderBodyRepeatKeyGenerator extends WebHeaderRepeatKeyGenerator {

    private final MD5 md5 = MD5.create();

    @Override
    public String generate(HttpServletRequest request) {
        String key = super.generate(request);
        if (key == null) {
            key = buildKeyByRequest(request);
        }
        return key;
    }

    private String buildKeyByRequest(HttpServletRequest request) {
        String rawBody = "";
        if (request instanceof CloudtRequestWrapper) {
            rawBody += (":&" + ObjectUtil.defaultIfNull(((CloudtRequestWrapper) request).getBodyString(), "emptyBody"));
        }
        rawBody += (":&" + request.getRequestURL().toString());
        rawBody += (":&" + ObjectUtil.defaultIfNull(request.getQueryString(), "emptyQuery"));
        rawBody += (":&" + ObjectUtil.defaultIfNull(getUserPrincipal(request), "emptyUser"));

        return md5.digestHex(rawBody);
    }

    private String getUserPrincipal(HttpServletRequest request) {
        var session = request.getSession(false);
        if (session != null) {
            return session.getId();
        }

        var user = request.getRemoteUser();
        if (StringUtils.hasText(user)) {
            return user;
        }

        var principal = request.getUserPrincipal();
        if (principal == null) {
            return null;
        }
        return principal.getName();
    }
}
