package com.elitescloud.boot.web.common;

import com.elitescloud.boot.constant.WebConstant;
import org.springframework.util.StringUtils;

import javax.servlet.http.HttpServletRequest;

/**
 * 使用前端传递的请求头.
 *
 * @author Kaiser（wang shao）
 * @date 2024/2/2
 */
public class WebHeaderRepeatKeyGenerator implements RepeatKeyGenerator {

    @Override
    public String generate(HttpServletRequest request) {
        // 从请求头中获取
        var repeat = request.getHeader(WebConstant.HEADER_REPEAT);
        if (StringUtils.hasText(repeat)) {
            return repeat;
        }
        return null;
    }
}
