package com.elitescloud.boot.web.config.filter;

import com.elitescloud.boot.context.CloudtRequestContextHolder;
import com.elitescloud.boot.support.CloudtInterceptor;
import org.springframework.lang.NonNull;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Web请求拦截器.
 *
 * @author Kaiser（wang shao）
 * @date 2023/12/28
 */
public class WebRequestInterceptor implements CloudtInterceptor {

    @Override
    public int order() {
        return Integer.MIN_VALUE;
    }

    @Override
    public boolean preHandle(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler) throws Exception {
        CloudtRequestContextHolder.setRequestAttributes(null);
        return true;
    }

    @Override
    public void afterCompletion(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler, Exception ex) throws Exception {
        CloudtRequestContextHolder.clear();
    }
}
