/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.web.common;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.crypto.digest.MD5;
import com.elitescloud.boot.web.common.WebHeaderRepeatKeyGenerator;
import com.elitescloud.boot.wrapper.CloudtRequestWrapper;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.util.StringUtils;

public class WebHeaderBodyRepeatKeyGenerator
extends WebHeaderRepeatKeyGenerator {
    private final MD5 md5 = MD5.create();

    @Override
    public String generate(HttpServletRequest request) {
        String key = super.generate(request);
        if (key == null) {
            key = this.buildKeyByRequest(request);
        }
        return key;
    }

    private String buildKeyByRequest(HttpServletRequest request) {
        Object rawBody = "";
        if (request instanceof CloudtRequestWrapper) {
            rawBody = (String)rawBody + ":&" + (String)ObjectUtil.defaultIfNull((Object)((CloudtRequestWrapper)request).getBodyString(), (Object)"emptyBody");
        }
        rawBody = (String)rawBody + ":&" + request.getRequestURL().toString();
        rawBody = (String)rawBody + ":&" + (String)ObjectUtil.defaultIfNull((Object)request.getQueryString(), (Object)"emptyQuery");
        rawBody = (String)rawBody + ":&" + (String)ObjectUtil.defaultIfNull((Object)this.getUserPrincipal(request), (Object)"emptyUser");
        return this.md5.digestHex((String)rawBody);
    }

    private String getUserPrincipal(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session != null) {
            return session.getId();
        }
        String user = request.getRemoteUser();
        if (StringUtils.hasText((String)user)) {
            return user;
        }
        Principal principal = request.getUserPrincipal();
        if (principal == null) {
            return null;
        }
        return principal.getName();
    }
}

