/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.web.config;

import com.elitescloud.boot.web.common.WebHeaderRepeatKeyGenerator;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@ConfigurationProperties(prefix="elitesland.web")
public class WebProperties {
    public static final String CONFIG_PREFIX = "elitesland.web";
    @NestedConfigurationProperty
    private WrapRequest wrapRequest = new WrapRequest();
    @NestedConfigurationProperty
    private RepeatRequest repeatRequest = new RepeatRequest();

    public WrapRequest getWrapRequest() {
        return this.wrapRequest;
    }

    public void setWrapRequest(WrapRequest wrapRequest) {
        this.wrapRequest = wrapRequest;
    }

    public RepeatRequest getRepeatRequest() {
        return this.repeatRequest;
    }

    public void setRepeatRequest(RepeatRequest repeatRequest) {
        this.repeatRequest = repeatRequest;
    }

    public static class WrapRequest {
        private boolean enabled = true;
        private boolean supportMultipart = false;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean getSupportMultipart() {
            return this.supportMultipart;
        }

        public void setSupportMultipart(boolean supportMultipart) {
            this.supportMultipart = supportMultipart;
        }
    }

    public static class RepeatRequest {
        private boolean enabled = false;
        private RepeatInterceptStrategy strategy = RepeatInterceptStrategy.AUTO;
        private String keyGenerator = WebHeaderRepeatKeyGenerator.class.getName();
        private boolean allowKeyEmpty = true;
        private int intervalMillis = 1000;
        private boolean useConfigForce = false;
        private int responseCode = 429;
        private int responseHttpStatus = 429;
        private String responseMsg = "\u91cd\u590d\u8bf7\u6c42";

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public RepeatInterceptStrategy getStrategy() {
            return this.strategy;
        }

        public void setStrategy(RepeatInterceptStrategy strategy) {
            this.strategy = strategy;
        }

        public String getKeyGenerator() {
            return this.keyGenerator;
        }

        public void setKeyGenerator(String keyGenerator) {
            this.keyGenerator = keyGenerator;
        }

        public boolean isAllowKeyEmpty() {
            return this.allowKeyEmpty;
        }

        public void setAllowKeyEmpty(boolean allowKeyEmpty) {
            this.allowKeyEmpty = allowKeyEmpty;
        }

        public int getIntervalMillis() {
            return this.intervalMillis;
        }

        public void setIntervalMillis(int intervalMillis) {
            this.intervalMillis = intervalMillis;
        }

        public boolean isUseConfigForce() {
            return this.useConfigForce;
        }

        public void setUseConfigForce(boolean useConfigForce) {
            this.useConfigForce = useConfigForce;
        }

        public int getResponseCode() {
            return this.responseCode;
        }

        public void setResponseCode(int responseCode) {
            this.responseCode = responseCode;
        }

        public int getResponseHttpStatus() {
            return this.responseHttpStatus;
        }

        public void setResponseHttpStatus(int responseHttpStatus) {
            this.responseHttpStatus = responseHttpStatus;
        }

        public String getResponseMsg() {
            return this.responseMsg;
        }

        public void setResponseMsg(String responseMsg) {
            this.responseMsg = responseMsg;
        }
    }

    public static enum RepeatInterceptStrategy {
        NEVER,
        AUTO,
        ALWAYS;

    }
}

