/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.web.config.filter;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitescloud.boot.support.CloudtInterceptor;
import com.elitescloud.boot.web.common.RepeatKeyGenerator;
import com.elitescloud.boot.web.config.WebProperties;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import java.lang.reflect.Constructor;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.web.method.HandlerMethod;

public class WebRequestRepeatInterceptor
implements CloudtInterceptor {
    private static final Logger log = LoggerFactory.getLogger(WebRequestRepeatInterceptor.class);
    private final RepeatKeyGenerator repeatKeyGenerator;
    private final RedisUtils redisUtils;
    private final WebProperties webProperties;

    public WebRequestRepeatInterceptor(RedisUtils redisUtils, WebProperties webProperties) {
        this.repeatKeyGenerator = this.loadRepeatKeyGenerator(webProperties.getRepeatRequest().getKeyGenerator());
        this.redisUtils = redisUtils;
        this.webProperties = webProperties;
        log.info("WebRequestRepeatInterceptor: {}, {}", (Object)webProperties.getRepeatRequest().getStrategy(), (Object)webProperties.getRepeatRequest().getIntervalMillis());
    }

    public int order() {
        return -2147483647;
    }

    public boolean preHandle(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler) throws Exception {
        if (!(handler instanceof HandlerMethod)) {
            log.debug("\u91cd\u590d\u8bf7\u6c42\u62e6\u622a\u8df3\u8fc7\uff1a{}", (Object)request.getRequestURI());
            return true;
        }
        WebProperties.RepeatRequest config = this.webProperties.getRepeatRequest();
        if (Boolean.FALSE.equals(config.isEnabled()) || config.getStrategy() == WebProperties.RepeatInterceptStrategy.NEVER) {
            return true;
        }
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        BusinessObjectOperation businessObjectOperation = (BusinessObjectOperation)handlerMethod.getMethodAnnotation(BusinessObjectOperation.class);
        if (config.getStrategy() == WebProperties.RepeatInterceptStrategy.AUTO && (businessObjectOperation == null || businessObjectOperation.allowRepeatRequest())) {
            return true;
        }
        int inverval = config.getIntervalMillis();
        if (businessObjectOperation != null && businessObjectOperation.repeatIntervalMillis() > 0) {
            inverval = businessObjectOperation.repeatIntervalMillis();
        }
        if (inverval < 0) {
            inverval = 1000;
        }
        if (this.allow(request, inverval)) {
            return true;
        }
        response.setStatus(config.getResponseHttpStatus());
        HttpServletUtil.writeJson((HttpServletResponse)response, (Object)ApiResult.fail((ApiCode)ApiCode.REQUEST_TOO_MANY, (String)config.getResponseMsg()));
        return false;
    }

    private boolean allow(HttpServletRequest request, int interval) {
        String key = this.repeatKeyGenerator.generate(request);
        if (key == null) {
            if (Boolean.TRUE.equals(this.webProperties.getRepeatRequest().isAllowKeyEmpty())) {
                log.warn("\u672a\u751f\u6210\u6709\u6548\u8bf7\u6c42\u6807\u8bc6\uff0c\u5141\u8bb8\u8bf7\u6c42\u91cd\u590d\uff1a{}", (Object)request.getRequestURI());
                return true;
            }
            return false;
        }
        Boolean result = this.redisUtils.getRedisTemplate().opsForValue().setIfAbsent((Object)key, (Object)"true", (long)interval, TimeUnit.MILLISECONDS);
        log.info("repeat request:{}, {}", (Object)key, (Object)result);
        if (result == null) {
            log.warn("\u5f53\u524dRedis\u4e0d\u652f\u6301setIfAbsent\u64cd\u4f5c\uff01");
            return true;
        }
        return result;
    }

    private RepeatKeyGenerator loadRepeatKeyGenerator(String className) {
        if (CharSequenceUtil.isBlank((CharSequence)className)) {
            throw new IllegalArgumentException("\u672a\u914d\u7f6e\u6709\u6548\u7684web\u91cd\u590d\u8c03\u7528\u5224\u65adkey\u751f\u6210\u5668\uff1aelitesland.web.repeat-request.key-generator");
        }
        Class<?> keyGeneratorClass = null;
        try {
            keyGeneratorClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            log.error("Key\u751f\u6210\u5668\u4e0d\u5b58\u5728\uff1a{}", (Object)className, (Object)e);
            throw new IllegalStateException(e);
        }
        if (!RepeatKeyGenerator.class.isAssignableFrom(keyGeneratorClass)) {
            throw new IllegalStateException(className + "\u672a\u5b9e\u73b0\u63a5\u53e3\uff1a" + RepeatKeyGenerator.class.getName());
        }
        Constructor<?> constructorNoArgs = null;
        try {
            constructorNoArgs = keyGeneratorClass.getConstructor(new Class[0]);
        }
        catch (Exception e) {
            log.error("{}\u52a0\u8f7d\u65e0\u53c2\u6784\u9020\u65b9\u6cd5\uff1a", (Object)className, (Object)e);
            throw new RuntimeException(e);
        }
        try {
            return (RepeatKeyGenerator)constructorNoArgs.newInstance(new Object[0]);
        }
        catch (Exception e) {
            log.error("\u521d\u59cb\u5316{}\u5f02\u5e38\uff1a", (Object)className, (Object)e);
            throw new RuntimeException(e);
        }
    }
}

