package com.elitescloud.boot.web.config;

import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.web.common.WebHeaderRepeatKeyGenerator;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

/**
 * web相关配置.
 *
 * @author Kaiser（wang shao）
 * @date 2022/8/21
 */
@ConfigurationProperties(prefix = WebProperties.CONFIG_PREFIX)
public class WebProperties {
    public static final String CONFIG_PREFIX = "elitesland.web";

    /**
     * 包装request
     */
    @NestedConfigurationProperty
    private WrapRequest wrapRequest = new WrapRequest();

    /**
     * 重复请求配置
     */
    @NestedConfigurationProperty
    private RepeatRequest repeatRequest = new RepeatRequest();

    public WrapRequest getWrapRequest() {
        return wrapRequest;
    }

    public void setWrapRequest(WrapRequest wrapRequest) {
        this.wrapRequest = wrapRequest;
    }

    public RepeatRequest getRepeatRequest() {
        return repeatRequest;
    }

    public void setRepeatRequest(RepeatRequest repeatRequest) {
        this.repeatRequest = repeatRequest;
    }

    public static class WrapRequest {
        /**
         * 是否启用包装request
         */
        private boolean enabled = true;

        /**
         * 是否支持对文件上传类请求的包装
         */
        private boolean supportMultipart = false;

        public boolean isEnabled() {
            return enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean getSupportMultipart() {
            return supportMultipart;
        }

        public void setSupportMultipart(boolean supportMultipart) {
            this.supportMultipart = supportMultipart;
        }
    }

    public static class RepeatRequest {

        /**
         * 是否启用拦截过滤器
         */
        private boolean enabled = false;

        /**
         * 拦截策略
         */
        private RepeatInterceptStrategy strategy = RepeatInterceptStrategy.AUTO;

        /**
         * key生成器
         */
        private String keyGenerator = WebHeaderRepeatKeyGenerator.class.getName();

        /**
         * 是否允许key为空
         * <p>
         * <li>true：允许为空，当需要拦截时，但未获取到有效key，则忽略拦截，继续执行业务；</li>
         * <li>false：不允许为空，当需要拦截时，但未获取到有效key，则返回重复请求响应。</li>
         */
        private boolean allowKeyEmpty = true;

        /**
         * 允许重复间隔
         */
        private int intervalMillis = 1000;

        /**
         * 是否强制使用配置
         * <p>
         * 如果未true，则忽略注解{@link BusinessObjectOperation#repeatIntervalMillis()}的值，而强制使用 {@link #intervalMillis}
         */
        private boolean useConfigForce = false;

        /**
         * 请求拦截后的响应码
         */
        private int responseCode = 429;

        /**
         * http响应码
         */
        private int responseHttpStatus = 429;

        private String responseMsg = "重复请求";

        public boolean isEnabled() {
            return enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public RepeatInterceptStrategy getStrategy() {
            return strategy;
        }

        public void setStrategy(RepeatInterceptStrategy strategy) {
            this.strategy = strategy;
        }

        public String getKeyGenerator() {
            return keyGenerator;
        }

        public void setKeyGenerator(String keyGenerator) {
            this.keyGenerator = keyGenerator;
        }

        public boolean isAllowKeyEmpty() {
            return allowKeyEmpty;
        }

        public void setAllowKeyEmpty(boolean allowKeyEmpty) {
            this.allowKeyEmpty = allowKeyEmpty;
        }

        public int getIntervalMillis() {
            return intervalMillis;
        }

        public void setIntervalMillis(int intervalMillis) {
            this.intervalMillis = intervalMillis;
        }

        public boolean isUseConfigForce() {
            return useConfigForce;
        }

        public void setUseConfigForce(boolean useConfigForce) {
            this.useConfigForce = useConfigForce;
        }

        public int getResponseCode() {
            return responseCode;
        }

        public void setResponseCode(int responseCode) {
            this.responseCode = responseCode;
        }

        public int getResponseHttpStatus() {
            return responseHttpStatus;
        }

        public void setResponseHttpStatus(int responseHttpStatus) {
            this.responseHttpStatus = responseHttpStatus;
        }

        public String getResponseMsg() {
            return responseMsg;
        }

        public void setResponseMsg(String responseMsg) {
            this.responseMsg = responseMsg;
        }
    }

    public static enum RepeatInterceptStrategy {
        /**
         * 从不拦截
         */
        NEVER,
        /**
         * 自动拦截
         * <p>
         * 当接口配置了{@link BusinessObjectOperation#allowRepeatRequest()} = false 时才进行拦截
         */
        AUTO,
        /**
         * 始终拦截
         * <p>
         * 自动拦截所有接口
         */
        ALWAYS
    }
}
