package com.elitescloud.boot.web.config;

import com.elitescloud.boot.common.servlet.CloudtRequestAttributes;
import com.elitescloud.boot.context.CloudtRequestContextHolder;
import com.elitescloud.boot.threadpool.common.ContextTransfer;
import org.springframework.web.context.request.RequestContextHolder;

/**
 * Request上下文传递.
 *
 * @author Kaiser（wang shao）
 * @date 2023/12/28
 */
public class ServletRequestContextTransfer implements ContextTransfer<CloudtRequestAttributes> {

    @Override
    public CloudtRequestAttributes getContext() {
        return CloudtRequestAttributes.getInstance();
    }

    @Override
    public void setContext(CloudtRequestAttributes context) {
        if (context == null) {
            return;
        }
        CloudtRequestContextHolder.setRequestAttributes(context);

        // 兼容设置web的
        RequestContextHolder.setRequestAttributes(context.getRequestAttributes());
    }

    @Override
    public void clearContext() {
        CloudtRequestContextHolder.clear();
        RequestContextHolder.resetRequestAttributes();
    }
}
