package com.elitescloud.boot.web.config.filter;

import com.elitescloud.boot.common.annotation.BusinessObject;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.constant.WebConstant;
import com.elitescloud.boot.context.CloudtRequestContextHolder;
import com.elitescloud.boot.context.ExecutorContextHolder;
import com.elitescloud.boot.support.CloudtInterceptor;
import org.springframework.lang.NonNull;
import org.springframework.web.method.HandlerMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Web请求拦截器.
 *
 * @author Kaiser（wang shao）
 * @date 2023/12/28
 */
public class WebRequestCommonInterceptor implements CloudtInterceptor {

    @Override
    public int order() {
        return Integer.MIN_VALUE;
    }

    @Override
    public boolean preHandle(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler) throws Exception {
        if (handler instanceof HandlerMethod) {
            this.setBusinessObjectAttribute(request, (HandlerMethod) handler);
        }

        CloudtRequestContextHolder.setRequestAttributes(null);
        ExecutorContextHolder.create(ExecutorContextHolder.Source.WEB, null, false);

        return true;
    }

    @Override
    public void afterCompletion(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler, Exception ex) throws Exception {
        CloudtRequestContextHolder.clear();
        ExecutorContextHolder.clear();
    }

    private void setBusinessObjectAttribute(HttpServletRequest request, HandlerMethod handlerMethod) {
        // 获取业务对象的操作
        var businessObjectOperation = handlerMethod.getMethodAnnotation(BusinessObjectOperation.class);
        if (businessObjectOperation != null) {
            request.setAttribute(WebConstant.ATTRIBUTE_BUSINESS_OPERATION, businessObjectOperation);
        }

        // 获取业务对象
        var businessObject = handlerMethod.getBeanType().getAnnotation(BusinessObject.class);
        if (businessObject == null) {
            return;
        }
        request.setAttribute(WebConstant.ATTRIBUTE_BUSINESS_OBJECT, businessObject);
    }
}
