package com.elitescloud.boot.web.common;

import org.springframework.web.method.HandlerMethod;

import java.lang.reflect.Method;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/4/25
 */
public interface InvocableHandlerMethodCustomizer {

    /**
     * 执行handler前的处理
     *
     * @param method     执行方法
     * @param parameters 执行参数
     * @return 参数
     */
    Object[] beforeInvoke(HandlerMethod method, Object[] parameters);

    /**
     * 执行handler前的处理
     *
     * @param bean       handler的类对象
     * @param method     执行方法
     * @param parameters 执行参数
     * @return 执行参数
     */
    Object[] beforeInvoke(Object bean, Method method, Object[] parameters);
}
