package com.elitescloud.boot.web.config;

import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitescloud.boot.web.config.filter.WebRequestRepeatInterceptor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;

/**
 * 重复请求配置.
 *
 * @author Kaiser（wang shao）
 * @date 2024/1/31
 */
@Slf4j
@ConditionalOnProperty(prefix = WebProperties.CONFIG_PREFIX + ".repeat-request", name = "enabled", havingValue = "true")
public class WebRepeatRequestConfig {

    private final WebProperties webProperties;

    public WebRepeatRequestConfig(WebProperties webProperties) {
        this.webProperties = webProperties;
    }

    @Bean
    public WebRequestRepeatInterceptor webRequestRepeatInterceptor(RedisUtils redisUtils) {
        return new WebRequestRepeatInterceptor(redisUtils, webProperties);
    }
}
