/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.web.config.filter;

import com.elitescloud.boot.common.annotation.BusinessObject;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.context.CloudtRequestContextHolder;
import com.elitescloud.boot.context.ExecutorContextHolder;
import com.elitescloud.boot.support.CloudtInterceptor;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.lang.NonNull;
import org.springframework.util.StringUtils;
import org.springframework.web.method.HandlerMethod;

public class WebRequestCommonInterceptor
implements CloudtInterceptor {
    public int order() {
        return Integer.MIN_VALUE;
    }

    public boolean preHandle(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler) throws Exception {
        if (handler instanceof HandlerMethod) {
            this.setBusinessObjectAttribute(request, (HandlerMethod)handler);
        }
        CloudtRequestContextHolder.setRequestAttributes(null);
        ExecutorContextHolder.Source source = StringUtils.hasText((String)request.getHeader("cloudt_traceId")) ? ExecutorContextHolder.Source.WEB_RPC : ExecutorContextHolder.Source.WEB;
        ExecutorContextHolder.create((ExecutorContextHolder.Source)source, null, (boolean)false);
        return true;
    }

    public void afterCompletion(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler, Exception ex) throws Exception {
        CloudtRequestContextHolder.clear();
        ExecutorContextHolder.clear();
    }

    private void setBusinessObjectAttribute(HttpServletRequest request, HandlerMethod handlerMethod) {
        BusinessObject businessObject;
        BusinessObjectOperation businessObjectOperation = (BusinessObjectOperation)handlerMethod.getMethodAnnotation(BusinessObjectOperation.class);
        if (businessObjectOperation != null) {
            request.setAttribute("cloudt-businessObject-operation", (Object)businessObjectOperation);
        }
        if ((businessObject = handlerMethod.getBeanType().getAnnotation(BusinessObject.class)) == null) {
            return;
        }
        request.setAttribute("cloudt-businessObject", (Object)businessObject);
    }
}

