package com.elitescloud.boot.web.common;

import org.springframework.lang.NonNull;
import org.springframework.web.servlet.DispatcherServlet;

/**
 * RequestMappingHandlerMapping自定义.
 *
 * @author Kaiser（wang shao）
 * @date 2024/4/24
 */
public interface RequestMappingHandlerMappingCustomizer {

    /**
     * 是否为处理器
     * <p>
     * 如果为true，则会交由 {@link DispatcherServlet}进行转发处理
     *
     * @param beanType bean类型
     * @return 是否为处理器
     */
    boolean isHandler(@NonNull Class<?> beanType);
}
