package com.elitescloud.boot.web.config;

import com.elitescloud.boot.web.common.InvocableHandlerMethodCustomizer;
import com.elitescloud.boot.web.common.RequestMappingHandlerMappingCustomizer;
import com.elitescloud.boot.web.config.support.CloudtWebMvcRegistrations;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcRegistrations;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;

/**
 * WebMVC自动化配置.
 *
 * @author Kaiser（wang shao）
 * @date 2024/4/24
 */
@Import({WebMvcConfig.class})
@AutoConfigureBefore(WebMvcAutoConfiguration.class)
public class CloudtWebMvcAutoConfiguration {

    @Bean
    public WebMvcRegistrations webMvcRegistrations(ObjectProvider<RequestMappingHandlerMappingCustomizer> requestMappingHandlerMappingCustomizerProvider,
                                                   ObjectProvider<InvocableHandlerMethodCustomizer> invocableHandlerMethodCustomizers) {
        return new CloudtWebMvcRegistrations(requestMappingHandlerMappingCustomizerProvider, invocableHandlerMethodCustomizers);
    }
}
