package com.elitescloud.boot.web.config.support;

import com.elitescloud.boot.web.common.InvocableHandlerMethodCustomizer;
import org.springframework.lang.NonNull;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.servlet.mvc.method.annotation.ServletInvocableHandlerMethod;

import java.util.List;

/**
 * 自定义RequestMappingHandlerAdapter.
 *
 * @author Kaiser（wang shao）
 * @date 2024/4/25
 */
public class CloudtRequestMappingHandlerAdapter extends RequestMappingHandlerAdapter {

    private final List<InvocableHandlerMethodCustomizer> invocableHandlerMethodCustomizers;

    public CloudtRequestMappingHandlerAdapter(List<InvocableHandlerMethodCustomizer> invocableHandlerMethodCustomizers) {
        this.invocableHandlerMethodCustomizers = invocableHandlerMethodCustomizers;
    }

    @NonNull
    @Override
    protected ServletInvocableHandlerMethod createInvocableHandlerMethod(@NonNull HandlerMethod handlerMethod) {
        return new CloudtServletInvocableHandlerMethod(invocableHandlerMethodCustomizers, handlerMethod);
    }
}
