package com.elitescloud.boot.web.config.support;

import com.elitescloud.boot.support.CloudtInterceptor;
import com.elitescloud.boot.web.common.InvocableHandlerMethodCustomizer;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.web.method.HandlerMethod;

import java.lang.reflect.Method;

/**
 * 拦截器中参数的回调处理.
 *
 * @author Kaiser（wang shao）
 * @date 2024/4/25
 */
public class InterceptorInvocableHandlerMethodCustomizer implements InvocableHandlerMethodCustomizer {

    private final ObjectProvider<CloudtInterceptor> interceptors;

    public InterceptorInvocableHandlerMethodCustomizer(ObjectProvider<CloudtInterceptor> interceptors) {
        this.interceptors = interceptors;
    }

    @Override
    public Object[] beforeInvoke(HandlerMethod method, Object[] parameters) {
        for (CloudtInterceptor interceptor : interceptors) {
            parameters = interceptor.beforeHandle(method, parameters);
        }
        return parameters;
    }

    @Override
    public Object[] beforeInvoke(Object bean, Method method, Object[] parameters) {
        for (CloudtInterceptor interceptor : interceptors) {
            parameters = interceptor.beforeHandle(method, parameters);
        }
        return parameters;
    }
}
