/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.web.config;

import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.common.servlet.CloudtRequestAttributes;
import com.elitescloud.boot.support.CloudtInterceptor;
import com.elitescloud.boot.support.app.CloudtAppHolder;
import com.elitescloud.boot.threadpool.common.ContextTransfer;
import com.elitescloud.boot.web.config.CloudtExceptionProperties;
import com.elitescloud.boot.web.config.ServletRequestContextTransfer;
import com.elitescloud.boot.web.config.WebProperties;
import com.elitescloud.boot.web.config.WebRepeatRequestConfig;
import com.elitescloud.boot.web.config.filter.WebRequestCommonInterceptor;
import com.elitescloud.boot.web.config.support.InterceptorInvocableHandlerMethodCustomizer;
import com.elitescloud.boot.web.exception.GlobalExceptionHandler;
import com.elitescloud.cloudt.common.base.ApiResult;
import java.util.HashMap;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.util.StringUtils;

@Import(value={WebRepeatRequestConfig.class})
@EnableConfigurationProperties(value={CloudtExceptionProperties.class})
class CloudtWebAutoConfiguration
implements InitializingBean {
    private final CloudtExceptionProperties exceptionProperties;

    public CloudtWebAutoConfiguration(CloudtExceptionProperties exceptionProperties) {
        this.exceptionProperties = exceptionProperties;
    }

    public void afterPropertiesSet() throws Exception {
        if (StringUtils.hasText((String)this.exceptionProperties.getGlobal().getDefaultMsgFormat())) {
            ApiResult.setErrorMsgConvert((errorCode, errorNo) -> {
                HashMap<String, String> params = new HashMap<String, String>(4);
                params.put("appName", CloudtAppHolder.getAppName());
                params.put("errorNo", (String)errorNo);
                return StrUtil.format((CharSequence)this.exceptionProperties.getGlobal().getDefaultMsgFormat(), params);
            });
        }
    }

    @Bean
    public WebRequestCommonInterceptor cloudtInterceptorWeb(WebProperties webProperties) {
        return new WebRequestCommonInterceptor(webProperties);
    }

    @Bean
    public InterceptorInvocableHandlerMethodCustomizer interceptorInvocableHandlerMethodCustomizer(ObjectProvider<CloudtInterceptor> interceptors) {
        return new InterceptorInvocableHandlerMethodCustomizer(interceptors);
    }

    @Bean
    public GlobalExceptionHandler globalExceptionHandler() {
        return new GlobalExceptionHandler(this.exceptionProperties);
    }

    @Bean
    public ContextTransfer<CloudtRequestAttributes> contextTransferRequestAttributes() {
        return new ServletRequestContextTransfer();
    }
}

