package com.elitescloud.boot.web.config.filter;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.web.config.WebProperties;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.MDC;
import org.springframework.lang.NonNull;
import org.springframework.web.filter.OncePerRequestFilter;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Map;

/**
 * 通用过滤器.
 *
 * @author Kaiser（wang shao）
 * @date 2024/4/30
 */
@Slf4j
public class WebRequestCommonFilter extends OncePerRequestFilter {

    private final WebProperties webProperties;

    public WebRequestCommonFilter(WebProperties webProperties) {
        this.webProperties = webProperties;
    }

    @Override
    protected void doFilterInternal(@NonNull HttpServletRequest request,@NonNull HttpServletResponse response,@NonNull FilterChain filterChain) throws ServletException, IOException {
        // 向响应头写入链路ID
        try {
            writeMdc(response);
        } catch (Exception e) {
            log.warn("write mdc exception: {}", e.getMessage());
        }

        filterChain.doFilter(request, response);
    }

    private void writeMdc(HttpServletResponse response) {
        var mdcList = webProperties.getResponse().getMdcMapping();
        if (CollUtil.isNotEmpty(mdcList)) {
            for (Map.Entry<String, String> entry : mdcList.entrySet()) {
                response.addHeader(entry.getKey(), MDC.get(entry.getValue()));
            }
        }
    }
}
