package com.elitescloud.boot.web.config.support;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.web.common.InvocableHandlerMethodCustomizer;
import org.springframework.context.MessageSource;
import org.springframework.lang.NonNull;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.annotation.ServletInvocableHandlerMethod;

import java.lang.reflect.Method;
import java.util.List;

/**
 * servlet执行handler方法.
 *
 * @author Kaiser（wang shao）
 * @date 2024/4/25
 */
public class CloudtServletInvocableHandlerMethod extends ServletInvocableHandlerMethod {

    private final List<InvocableHandlerMethodCustomizer> handlerMethodCustomizers;
    private final HandlerMethod handlerMethod;
    private final Object bean;
    private final Method method;

    public CloudtServletInvocableHandlerMethod(List<InvocableHandlerMethodCustomizer> handlerMethodCustomizers, HandlerMethod handlerMethod) {
        super(handlerMethod);
        this.handlerMethodCustomizers = handlerMethodCustomizers;
        this.handlerMethod = handlerMethod;
        this.bean = null;
        this.method = null;
    }

    public CloudtServletInvocableHandlerMethod(List<InvocableHandlerMethodCustomizer> handlerMethodCustomizers, Object bean, Method method) {
        super(bean, method);
        this.handlerMethodCustomizers = handlerMethodCustomizers;
        this.handlerMethod = null;
        this.bean = bean;
        this.method = method;
    }

    protected CloudtServletInvocableHandlerMethod(List<InvocableHandlerMethodCustomizer> handlerMethodCustomizers, Object bean, Method method, MessageSource messageSource) {
        super(bean, method, messageSource);
        this.handlerMethodCustomizers = handlerMethodCustomizers;
        this.handlerMethod = null;
        this.bean = bean;
        this.method = method;
    }

    @Override
    protected Object doInvoke(@NonNull Object... args) throws Exception {
        // 前置回调
        if (CollUtil.isNotEmpty(handlerMethodCustomizers)) {
            for (InvocableHandlerMethodCustomizer customizer : handlerMethodCustomizers) {
                if (handlerMethod != null) {
                    args = customizer.beforeInvoke(handlerMethod, args);
                    continue;
                }

                if (bean != null && method != null) {
                    args = customizer.beforeInvoke(bean, method, args);
                }
            }
        }

        // 调用原逻辑
        return super.doInvoke(args);
    }
}
