package com.elitescloud.boot.web.config.support;

import com.elitescloud.boot.web.common.InvocableHandlerMethodCustomizer;
import com.elitescloud.boot.web.common.RequestMappingHandlerMappingCustomizer;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcRegistrations;
import org.springframework.lang.NonNull;
import org.springframework.web.servlet.mvc.method.annotation.ExceptionHandlerExceptionResolver;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

import java.util.stream.Collectors;

/**
 * 自定义webMvc注册点.
 *
 * @author Kaiser（wang shao）
 * @date 2024/4/24
 */
public class CloudtWebMvcRegistrations implements WebMvcRegistrations {

    private final ObjectProvider<RequestMappingHandlerMappingCustomizer> requestMappingHandlerMappingCustomizers;
    private final ObjectProvider<InvocableHandlerMethodCustomizer> invocableHandlerMethodCustomizers;

    public CloudtWebMvcRegistrations(ObjectProvider<RequestMappingHandlerMappingCustomizer> requestMappingHandlerMappingCustomizers,
                                     ObjectProvider<InvocableHandlerMethodCustomizer> invocableHandlerMethodCustomizers) {
        this.requestMappingHandlerMappingCustomizers = requestMappingHandlerMappingCustomizers;
        this.invocableHandlerMethodCustomizers = invocableHandlerMethodCustomizers;
    }

    @Override
    public RequestMappingHandlerMapping getRequestMappingHandlerMapping() {
        return new RequestMappingHandlerMapping() {
            @Override
            protected boolean isHandler(@NonNull Class<?> beanType) {
                if (!super.isHandler(beanType)) {
                    return false;
                }

                for (RequestMappingHandlerMappingCustomizer customizer : requestMappingHandlerMappingCustomizers) {
                    if (!customizer.isHandler(beanType)) {
                        return false;
                    }
                }
                return true;
            }
        };
    }

    @Override
    public RequestMappingHandlerAdapter getRequestMappingHandlerAdapter() {
        return new CloudtRequestMappingHandlerAdapter(invocableHandlerMethodCustomizers.stream().collect(Collectors.toList()));
    }

    @Override
    public ExceptionHandlerExceptionResolver getExceptionHandlerExceptionResolver() {
        return WebMvcRegistrations.super.getExceptionHandlerExceptionResolver();
    }
}
