/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.web.config.filter;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.web.config.WebProperties;
import java.io.IOException;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.lang.NonNull;
import org.springframework.web.filter.OncePerRequestFilter;

public class WebRequestCommonFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(WebRequestCommonFilter.class);
    private final WebProperties webProperties;

    public WebRequestCommonFilter(WebProperties webProperties) {
        this.webProperties = webProperties;
    }

    protected void doFilterInternal(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull FilterChain filterChain) throws ServletException, IOException {
        try {
            this.writeMdc(response);
        }
        catch (Exception e) {
            log.warn("write mdc exception: {}", (Object)e.getMessage());
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private void writeMdc(HttpServletResponse response) {
        Map<String, String> mdcList = this.webProperties.getResponse().getMdcMapping();
        if (CollUtil.isNotEmpty(mdcList)) {
            for (Map.Entry<String, String> entry : mdcList.entrySet()) {
                response.addHeader(entry.getKey(), MDC.get((String)entry.getValue()));
            }
        }
    }
}

