/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.web.config.filter;

import com.elitescloud.boot.common.annotation.BusinessObject;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.context.CloudtRequestContextHolder;
import com.elitescloud.boot.context.ExecutorContextHolder;
import com.elitescloud.boot.support.CloudtInterceptor;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import java.io.IOException;
import java.lang.reflect.Type;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.lang.NonNull;
import org.springframework.util.StringUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.annotation.RequestBodyAdvice;

public class WebRequestCommonInterceptor
implements CloudtInterceptor,
RequestBodyAdvice {
    public int order() {
        return Integer.MIN_VALUE;
    }

    public boolean preHandle(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler) throws Exception {
        if (handler instanceof HandlerMethod) {
            this.setBusinessObjectAttribute(request, (HandlerMethod)handler);
        }
        CloudtRequestContextHolder.setRequestAttributes(null);
        ExecutorContextHolder.Source source = StringUtils.hasText((String)request.getHeader("cloudt_traceId")) ? ExecutorContextHolder.Source.WEB_RPC : ExecutorContextHolder.Source.WEB;
        ExecutorContextHolder.create((ExecutorContextHolder.Source)source, null, (boolean)false);
        return true;
    }

    public boolean supports(@NonNull MethodParameter methodParameter, @NonNull Type targetType, @NonNull Class<? extends HttpMessageConverter<?>> converterType) {
        return true;
    }

    @NonNull
    public HttpInputMessage beforeBodyRead(@NonNull HttpInputMessage inputMessage, @NonNull MethodParameter parameter, @NonNull Type targetType, @NonNull Class<? extends HttpMessageConverter<?>> converterType) throws IOException {
        return inputMessage;
    }

    @NonNull
    public Object afterBodyRead(@NonNull Object body, @NonNull HttpInputMessage inputMessage, @NonNull MethodParameter parameter, @NonNull Type targetType, @NonNull Class<? extends HttpMessageConverter<?>> converterType) {
        HttpServletRequest request = HttpServletUtil.currentRequest();
        if (request != null) {
            request.setAttribute("cloudt-requestBody", body);
        }
        return body;
    }

    public Object handleEmptyBody(Object body, @NonNull HttpInputMessage inputMessage, @NonNull MethodParameter parameter, @NonNull Type targetType, @NonNull Class<? extends HttpMessageConverter<?>> converterType) {
        return body;
    }

    public void afterCompletion(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler, Exception ex) throws Exception {
        CloudtRequestContextHolder.clear();
        ExecutorContextHolder.clear();
    }

    private void setBusinessObjectAttribute(HttpServletRequest request, HandlerMethod handlerMethod) {
        BusinessObject businessObject;
        BusinessObjectOperation businessObjectOperation = (BusinessObjectOperation)handlerMethod.getMethodAnnotation(BusinessObjectOperation.class);
        if (businessObjectOperation != null) {
            request.setAttribute("cloudt-businessObject-operation", (Object)businessObjectOperation);
        }
        if ((businessObject = handlerMethod.getBeanType().getAnnotation(BusinessObject.class)) == null) {
            return;
        }
        request.setAttribute("cloudt-businessObject", (Object)businessObject);
    }
}

