/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.web.common.support;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.util.ObjUtil;
import com.elitescloud.boot.web.common.param.SignatureConfigParam;
import com.elitescloud.boot.web.common.param.SignatureContent;
import java.util.LinkedHashMap;
import java.util.StringJoiner;
import org.springframework.http.HttpMethod;

abstract class AbstractApiSignatureContentProvider {
    public static final String ADD_SIGN_TIMESTAMP = "X-Cloudt-SignTime";
    public static final String ADD_SIGN_RANDOM = "X-Cloudt-SignRandom";

    AbstractApiSignatureContentProvider() {
    }

    protected SignatureContent generateSignature(HttpMethod httpMethod, String url, String body, SignatureConfigParam configParam, String timestamp, String random) {
        StringJoiner joiner = new StringJoiner("&");
        joiner.add((CharSequence)ObjUtil.defaultIfNull((Object)configParam.getAppId(), (Object)""));
        if (httpMethod != null) {
            joiner.add(httpMethod.name());
        }
        if (url != null) {
            joiner.add(url);
        }
        if (body != null) {
            joiner.add(body);
        }
        joiner.add(timestamp);
        joiner.add(random);
        SignatureContent content = new SignatureContent();
        content.setContent(joiner.toString());
        content.setAdditionalParams(new LinkedHashMap<String, String>(8));
        content.getAdditionalParams().put(this.getParamNameTimestamp(configParam), timestamp);
        content.getAdditionalParams().put(this.getParamNameRandom(configParam), random);
        return content;
    }

    protected String getParamNameTimestamp(SignatureConfigParam configParam) {
        return CharSequenceUtil.blankToDefault((CharSequence)configParam.getSignatureTimestampParamName(), (String)ADD_SIGN_TIMESTAMP);
    }

    protected String getParamNameRandom(SignatureConfigParam configParam) {
        return CharSequenceUtil.blankToDefault((CharSequence)configParam.getSignatureRandomParamName(), (String)ADD_SIGN_RANDOM);
    }
}

