/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.web.common.support;

import com.elitescloud.boot.common.constant.EncryptAlgorithm;
import com.elitescloud.boot.common.constant.EncryptFormatType;
import com.elitescloud.boot.web.common.param.SignatureConfigParam;
import com.elitescloud.boot.web.common.param.SignatureModel;
import com.elitescloud.boot.web.common.signature.ApiSignatureParamProvider;
import com.elitescloud.boot.web.config.WebProperties;
import org.springframework.http.HttpMethod;

public class DefaultApiSignatureParamProvider
implements ApiSignatureParamProvider {
    private final WebProperties webProperties;

    public DefaultApiSignatureParamProvider(WebProperties webProperties) {
        this.webProperties = webProperties;
    }

    @Override
    public SignatureConfigParam get(HttpMethod httpMethod, String url, SignatureModel model) {
        SignatureConfigParam param = new SignatureConfigParam();
        param.setAppId(this.webProperties.getApiSign().getAppId());
        param.setEncryptAlgorithm(EncryptAlgorithm.RSA);
        param.setEncryptFormatType(EncryptFormatType.PKCS8);
        param.setPublicKey(this.webProperties.getApiSign().getPublicKey());
        param.setPrivateKey(this.webProperties.getApiSign().getPrivateKey());
        param.setSignatureAlgorithm(this.webProperties.getApiSign().getSignatureAlgorithm());
        param.setSignatureParamIn(this.webProperties.getApiSign().getSignatureParamIn());
        param.setSignatureParamName(this.webProperties.getApiSign().getSignatureParamName());
        param.setSignatureTimestampParamName(this.webProperties.getApiSign().getSignatureTimestampParamName());
        param.setSignatureRandomParamName(this.webProperties.getApiSign().getSignatureRandomParamName());
        return param;
    }
}

