/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.web.common.support;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import com.elitescloud.boot.common.constant.EncryptAlgorithm;
import com.elitescloud.boot.common.constant.EncryptFormatType;
import com.elitescloud.boot.common.constant.SignatureAlgorithm;
import com.elitescloud.boot.util.RsaUtil;
import com.elitescloud.boot.web.common.param.Signature;
import com.elitescloud.boot.web.common.param.SignatureConfigParam;
import com.elitescloud.boot.web.common.param.SignatureContent;
import com.elitescloud.boot.web.common.param.SignatureModel;
import com.elitescloud.boot.web.common.signature.ApiSignatureContentProvider;
import com.elitescloud.boot.web.common.signature.ApiSignatureParamProvider;
import com.elitescloud.boot.web.common.signature.ApiSignatureProvider;
import com.elitescloud.boot.web.common.signature.ApiVerifySignatureContentProvider;
import com.elitescloud.boot.web.config.WebProperties;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.slf4j.Logger;
import org.springframework.http.HttpMethod;

public class DefaultApiSignatureProvider
implements ApiSignatureProvider {
    private static final Logger logger = CloudtBootLoggerFactory.WEB_SIGN.getLogger(DefaultApiSignatureProvider.class);
    private final WebProperties webProperties;
    private final ApiSignatureParamProvider paramProvider;
    private final ApiSignatureContentProvider signatureContentProvider;
    private final ApiVerifySignatureContentProvider verifySignatureContentProvider;

    public DefaultApiSignatureProvider(WebProperties webProperties, ApiSignatureParamProvider paramProvider, ApiSignatureContentProvider signatureContentProvider, ApiVerifySignatureContentProvider verifySignatureContentProvider) {
        this.webProperties = webProperties;
        this.paramProvider = paramProvider;
        this.signatureContentProvider = signatureContentProvider;
        this.verifySignatureContentProvider = verifySignatureContentProvider;
    }

    @Override
    public SignatureConfigParam getConfig(HttpMethod httpMethod, String url, SignatureModel model) {
        try {
            return this.paramProvider.get(httpMethod, url, model);
        }
        catch (Exception e) {
            throw new IllegalStateException("\u83b7\u53d6\u52a0\u5bc6\u53c2\u6570\u914d\u7f6e\u5f02\u5e38", e);
        }
    }

    @Override
    public boolean needSignature(HttpMethod httpMethod, String url) {
        return this.webProperties.getApiSign().isEnabled();
    }

    @Override
    public Signature sign(HttpMethod httpMethod, String url, String body) {
        return this.sign(httpMethod, url, body, null);
    }

    @Override
    public Signature sign(HttpMethod httpMethod, String url, String body, SignatureConfigParam configParam) {
        if (configParam == null) {
            configParam = this.getConfig(httpMethod, url, SignatureModel.SIGN);
        }
        if (configParam == null) {
            logger.info("\u672a\u83b7\u53d6\u5230\u7b7e\u540d\u914d\u7f6e\uff0c\u5ffd\u7565\u7b7e\u540d\uff1a{}", (Object)(httpMethod + ":" + url));
            return null;
        }
        String signature = null;
        SignatureContent signatureContent = null;
        try {
            signatureContent = this.signatureContentProvider.produce(httpMethod, url, body, configParam);
            Assert.notNull((Object)signatureContent, (String)"\u7b7e\u540d\u5185\u5bb9\u4e3a\u7a7a", (Object[])new Object[0]);
            logger.info("\u7b7e\u540d\u5185\u5bb9\uff1a{}\uff0c\u989d\u5916\u53c2\u6570\uff1a{}", (Object)signatureContent.getContent(), signatureContent.getAdditionalParams());
            PrivateKey privateKey = this.readPrivateKey(configParam.getEncryptAlgorithm(), configParam.getEncryptFormatType(), configParam.getPrivateKey());
            signature = this.generateSignature(signatureContent.getContent(), configParam.getEncryptAlgorithm(), privateKey, configParam.getSignatureAlgorithm());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u751f\u6210\u7b7e\u540d\u5931\u8d25\uff0c" + e.getMessage(), e);
        }
        logger.info("\u751f\u6210\u7b7e\u540d\uff1a{}\uff0c{}", (Object)(httpMethod + ":" + url), (Object)signature);
        return new Signature(signature, signatureContent.getAdditionalParams());
    }

    @Override
    public boolean needVerifySignature(HttpMethod httpMethod, String url) {
        return this.webProperties.getApiSign().isEnabled();
    }

    @Override
    public boolean verifySign(HttpMethod httpMethod, String url, String body, String sign) {
        return this.verifySign(httpMethod, url, body, sign, null);
    }

    @Override
    public boolean verifySign(HttpMethod httpMethod, String url, String body, String sign, SignatureConfigParam configParam) {
        if (configParam == null) {
            configParam = this.getConfig(httpMethod, url, SignatureModel.VERIFY_SIGN);
        }
        if (configParam == null) {
            logger.info("\u672a\u83b7\u53d6\u5230\u9a8c\u7b7e\u914d\u7f6e\uff0c\u5ffd\u7565\u9a8c\u7b7e\uff1a{}", (Object)(httpMethod + ":" + url));
            return true;
        }
        boolean result = false;
        String signature = null;
        try {
            signature = this.verifySignatureContentProvider.produce(httpMethod, url, body, configParam);
            Assert.notNull((Object)signature, (String)"\u5f85\u9a8c\u8bc1\u7b7e\u540d\u5185\u5bb9\u4e3a\u7a7a", (Object[])new Object[0]);
            logger.info("\u5f85\u9a8c\u8bc1\u7b7e\u540d\u5185\u5bb9\uff1a{}", (Object)signature);
            PublicKey publicKey = this.readPublicKey(configParam.getEncryptAlgorithm(), configParam.getEncryptFormatType(), configParam.getPublicKey());
            result = this.verifySignature(signature, sign, configParam.getEncryptAlgorithm(), publicKey, configParam.getSignatureAlgorithm().name());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u9a8c\u8bc1\u7b7e\u540d\u5931\u8d25\uff0c" + e.getMessage(), e);
        }
        logger.info("\u6821\u9a8c\u7b7e\u540d\uff1a{}\uff0c{}\uff0c{}", new Object[]{httpMethod + ":" + url, sign, result});
        return result;
    }

    private PrivateKey readPrivateKey(EncryptAlgorithm encryptAlgorithm, EncryptFormatType formatType, String privateKey) throws Exception {
        if (EncryptAlgorithm.RSA == encryptAlgorithm) {
            if (EncryptFormatType.PKCS1 == formatType) {
                return RsaUtil.convert2PrivateKeyForPkcs1((String)privateKey);
            }
            return RsaUtil.convert2PrivateKey((String)privateKey);
        }
        throw new IllegalStateException("\u6682\u4e0d\u652f\u6301\u7684\u52a0\u5bc6\u7b97\u6cd5" + encryptAlgorithm);
    }

    private PublicKey readPublicKey(EncryptAlgorithm encryptAlgorithm, EncryptFormatType formatType, String publicKey) throws Exception {
        if (EncryptAlgorithm.RSA == encryptAlgorithm) {
            if (EncryptFormatType.PKCS1 == formatType) {
                return RsaUtil.convert2PublicKeyForPkcs1((String)publicKey);
            }
            return RsaUtil.convert2PublicKey((String)publicKey);
        }
        throw new IllegalStateException("\u6682\u4e0d\u652f\u6301\u7684\u52a0\u5bc6\u7b97\u6cd5" + encryptAlgorithm);
    }

    private String generateSignature(String body, EncryptAlgorithm encryptAlgorithm, PrivateKey privateKey, SignatureAlgorithm signatureAlgorithm) {
        if (EncryptAlgorithm.RSA == encryptAlgorithm) {
            return RsaUtil.sign((PrivateKey)privateKey, (String)signatureAlgorithm.name(), (String)body);
        }
        throw new IllegalStateException("\u6682\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u7b97\u6cd5" + encryptAlgorithm);
    }

    private boolean verifySignature(String body, String signature, EncryptAlgorithm encryptAlgorithm, PublicKey publicKey, String signatureAlgorithm) {
        if (EncryptAlgorithm.RSA == encryptAlgorithm) {
            return RsaUtil.verifySign((PublicKey)publicKey, (String)signatureAlgorithm, (String)body, (String)signature);
        }
        throw new IllegalStateException("\u6682\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u7b97\u6cd5" + encryptAlgorithm);
    }
}

