/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.web.config.filter;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.support.CloudtInterceptor;
import com.elitescloud.boot.util.JSONUtil;
import com.elitescloud.boot.web.common.param.ApiSignatureParamIn;
import com.elitescloud.boot.web.common.param.Signature;
import com.elitescloud.boot.web.common.param.SignatureConfigParam;
import com.elitescloud.boot.web.common.param.SignatureModel;
import com.elitescloud.boot.web.common.signature.ApiSignature;
import com.elitescloud.boot.web.common.signature.ApiSignatureProvider;
import com.elitescloud.boot.web.config.WebProperties;
import com.elitescloud.boot.wrapper.CloudtRequestWrapper;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.lang.NonNull;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@ConditionalOnProperty(prefix="elitesland.web.api-sign", name={"enabled"}, havingValue="true")
@ControllerAdvice
public class ApiSignatureInterceptor
implements CloudtInterceptor,
ResponseBodyAdvice<Object> {
    private static final Logger logger = CloudtBootLoggerFactory.WEB_SIGN.getLogger(ApiSignatureInterceptor.class);
    private static final Map<Method, ApiSignatureWrapper> API_SIGNATURE_CACHE = new HashMap<Method, ApiSignatureWrapper>(1024);
    private final ThreadLocal<ApiSignature> apiSignatureThreadLocal = new ThreadLocal();
    private final WebProperties webProperties;
    private final ApiSignatureProvider apiSignatureProvider;

    public ApiSignatureInterceptor(WebProperties webProperties, ApiSignatureProvider apiSignatureProvider) {
        this.webProperties = webProperties;
        this.apiSignatureProvider = apiSignatureProvider;
    }

    public boolean preHandle(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler) throws Exception {
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        if (Boolean.FALSE.equals(this.webProperties.getApiSign().isEnabled())) {
            return true;
        }
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        ApiSignature apiSignature = this.obtainApiSignature(handlerMethod);
        if (apiSignature == null) {
            return true;
        }
        this.apiSignatureThreadLocal.set(apiSignature);
        if (SignatureModel.SIGN == apiSignature.model()) {
            return true;
        }
        if (SignatureModel.VERIFY_SIGN == apiSignature.model()) {
            boolean verifyResult = false;
            try {
                verifyResult = this.verifySign(request);
            }
            catch (Exception e) {
                logger.error("\u6821\u9a8c\u7b7e\u540d\u5f02\u5e38\uff1a{}", (Object)(handlerMethod.getMethod().getDeclaringClass().getName() + "." + handlerMethod.getMethod().getName()), (Object)e);
                HttpServletUtil.writeJson((HttpServletResponse)response, (Object)ApiResult.fail((ApiCode)ApiCode.SYSTEM_EXCEPTION, (String)"\u670d\u52a1\u5668\u5f02\u5e38"));
                return false;
            }
            logger.debug("\u9a8c\u7b7e\u7ed3\u679c\uff1a{}, {}", (Object)request.getRequestURI(), (Object)verifyResult);
            if (verifyResult) {
                return true;
            }
            HttpServletUtil.writeJson((HttpServletResponse)response, (Object)ApiResult.fail((ApiCode)ApiCode.SIGNATURE_ERROR, (String)"\u7b7e\u540d\u6821\u9a8c\u4e0d\u901a\u8fc7"));
            return false;
        }
        return true;
    }

    public boolean supports(@NonNull MethodParameter returnType, @NonNull Class<? extends HttpMessageConverter<?>> converterType) {
        return true;
    }

    public Object beforeBodyWrite(Object body, @NonNull MethodParameter returnType, @NonNull MediaType selectedContentType, @NonNull Class<? extends HttpMessageConverter<?>> selectedConverterType, @NonNull ServerHttpRequest request, @NonNull ServerHttpResponse response) {
        if (body != null && request instanceof ServletServerHttpRequest && response instanceof ServletServerHttpResponse) {
            try {
                this.setSignature(((ServletServerHttpRequest)request).getServletRequest(), ((ServletServerHttpResponse)response).getServletResponse(), body);
            }
            catch (Exception e) {
                logger.error("\u8bbe\u7f6e\u7b7e\u540d\u5f02\u5e38\uff1a{}", (Object)request.getURI(), (Object)e);
            }
        }
        return body;
    }

    private void setSignature(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, Object body) {
        String uri;
        ApiSignature apiSignature = this.apiSignatureThreadLocal.get();
        this.apiSignatureThreadLocal.remove();
        if (body == null || apiSignature == null) {
            return;
        }
        if (Boolean.FALSE.equals(this.webProperties.getApiSign().isEnabled()) || apiSignature.model() != SignatureModel.SIGN) {
            return;
        }
        HttpMethod method = HttpMethod.resolve((String)request.getMethod());
        if (!this.apiSignatureProvider.needSignature(method, uri = request.getRequestURI())) {
            return;
        }
        SignatureConfigParam cfg = this.apiSignatureProvider.getConfig(method, uri, SignatureModel.SIGN);
        if (cfg == null) {
            return;
        }
        String bodyStr = JSONUtil.toJsonString((Object)body);
        Signature signature = this.apiSignatureProvider.sign(method, uri, bodyStr, cfg);
        if (cfg.getSignatureParamIn() == ApiSignatureParamIn.HEADER) {
            response.addHeader(cfg.getSignatureParamName(), signature.getSiginature());
            if (CollUtil.isNotEmpty(signature.getAdditionalParam())) {
                signature.getAdditionalParam().forEach((arg_0, arg_1) -> ((HttpServletResponse)response).addHeader(arg_0, arg_1));
            }
        } else {
            throw new BusinessException("\u6682\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u4f4d\u7f6e" + cfg.getSignatureParamIn());
        }
    }

    private boolean verifySign(HttpServletRequest request) {
        String uri;
        HttpMethod method = HttpMethod.resolve((String)request.getMethod());
        if (!this.apiSignatureProvider.needVerifySignature(method, uri = request.getRequestURI())) {
            return true;
        }
        SignatureConfigParam cfg = this.apiSignatureProvider.getConfig(method, uri, SignatureModel.VERIFY_SIGN);
        if (cfg == null) {
            return true;
        }
        String signatureValue = this.obtainSignature(cfg, request);
        if (CharSequenceUtil.isBlank((CharSequence)signatureValue)) {
            logger.info("\u672a\u83b7\u53d6\u5230\u7b7e\u540d\uff1a{}", (Object)uri);
            return false;
        }
        if (!(request instanceof CloudtRequestWrapper)) {
            throw new IllegalStateException("\u83b7\u53d6\u8bf7\u6c42\u5934\u5f02\u5e38");
        }
        String bodyStr = ((CloudtRequestWrapper)request).getBodyString();
        if (CharSequenceUtil.isBlank((CharSequence)bodyStr)) {
            logger.warn("\u9a8c\u7b7e\u5931\u8d25\uff0c\u8bf7\u6c42\u5934\u4e3a\u7a7a");
            return false;
        }
        return this.apiSignatureProvider.verifySign(method, uri, bodyStr, signatureValue, cfg);
    }

    private String obtainSignature(SignatureConfigParam configParam, HttpServletRequest request) {
        if (configParam.getSignatureParamIn() == ApiSignatureParamIn.HEADER) {
            return request.getHeader(configParam.getSignatureParamName());
        }
        return request.getParameter(configParam.getSignatureParamName());
    }

    private ApiSignature obtainApiSignature(HandlerMethod handlerMethod) {
        Method method = handlerMethod.getMethod();
        ApiSignatureWrapper apiSignatureWrapper = API_SIGNATURE_CACHE.computeIfAbsent(method, k -> new ApiSignatureWrapper(method));
        return apiSignatureWrapper.getApiSignature();
    }

    private static class ApiSignatureWrapper {
        private final Method method;
        private ApiSignature apiSignature;

        public ApiSignatureWrapper(Method method) {
            this.method = method;
            this.init();
        }

        public ApiSignature getApiSignature() {
            return this.apiSignature;
        }

        private void init() {
            ApiSignature anno = this.method.getAnnotation(ApiSignature.class);
            if (anno != null) {
                this.apiSignature = anno;
                return;
            }
            this.apiSignature = this.method.getDeclaringClass().getAnnotation(ApiSignature.class);
        }
    }
}

