/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.web.common.support;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import com.elitescloud.boot.web.common.param.ApiSignatureParamIn;
import com.elitescloud.boot.web.common.param.Signature;
import com.elitescloud.boot.web.common.param.SignatureConfigParam;
import com.elitescloud.boot.web.common.param.SignatureModel;
import com.elitescloud.boot.web.common.signature.ApiSignatureProvider;
import com.elitescloud.boot.web.config.WebProperties;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.lang.NonNull;

public class ApiSignatureClientHttpRequestInterceptor
implements ClientHttpRequestInterceptor {
    private static final Logger logger = CloudtBootLoggerFactory.WEB_SIGN.getLogger(ApiSignatureClientHttpRequestInterceptor.class);
    private final WebProperties webProperties;
    private final ApiSignatureProvider apiSignatureProvider;

    public ApiSignatureClientHttpRequestInterceptor(WebProperties webProperties, ApiSignatureProvider apiSignatureProvider) {
        this.webProperties = webProperties;
        this.apiSignatureProvider = apiSignatureProvider;
    }

    public ClientHttpResponse intercept(@NonNull HttpRequest request, @NonNull byte[] body, @NonNull ClientHttpRequestExecution execution) throws IOException {
        String uri;
        if (!this.webProperties.getApiSign().isEnabled()) {
            logger.info("\u63a5\u53e3\u7b7e\u540d\u672a\u542f\u7528");
            return execution.execute(request, body);
        }
        HttpMethod method = request.getMethod();
        boolean needSignature = this.apiSignatureProvider.needSignature(method, uri = request.getURI().getRawPath());
        if (needSignature) {
            logger.info("\u63a5\u53e3\u7b7e\u540d\uff1a{}\uff0c{}", (Object)uri, (Object)method);
            SignatureConfigParam cfg = this.apiSignatureProvider.getConfig(method, uri, SignatureModel.SIGN);
            if (cfg == null) {
                logger.error("\u63a5\u53e3\u7b7e\u540d\u914d\u7f6e\u672a\u627e\u5230\uff1a{}\uff0c{}\uff0c\u5ffd\u7565\u6821\u9a8c", (Object)uri, (Object)method);
                return execution.execute(request, body);
            }
            String bodyStr = new String(body, StandardCharsets.UTF_8);
            Signature signature = this.apiSignatureProvider.sign(method, uri, bodyStr, cfg);
            logger.info("\u751f\u6210\u63a5\u53e3\u7b7e\u540d\uff1a{}", (Object)signature.getSiginature());
            if (cfg.getSignatureParamIn() == ApiSignatureParamIn.HEADER) {
                request.getHeaders().add(cfg.getSignatureParamName(), signature.getSiginature());
                if (CollUtil.isNotEmpty(signature.getAdditionalParam())) {
                    signature.getAdditionalParam().forEach((k, v) -> request.getHeaders().add(k, v));
                }
            } else {
                logger.error("\u6682\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u4f4d\u7f6e\uff1a{}", (Object)cfg.getSignatureParamIn());
            }
        }
        return execution.execute(request, body);
    }
}

