/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.web.config.filter;

import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import com.elitescloud.boot.common.annotation.BusinessObject;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.context.CloudtRequestContextHolder;
import com.elitescloud.boot.context.ExecutorContextHolder;
import com.elitescloud.boot.provider.CurrentUserProvider;
import com.elitescloud.boot.support.CloudtInterceptor;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import java.io.IOException;
import java.lang.reflect.Type;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.lang.NonNull;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.annotation.RequestBodyAdvice;

@ControllerAdvice
public class WebRequestCommonInterceptor
implements CloudtInterceptor,
RequestBodyAdvice {
    private static final Logger logger = CloudtBootLoggerFactory.WEB.getLogger(WebRequestCommonInterceptor.class);
    private CurrentUserProvider currentUserProvider;

    public int order() {
        return Integer.MIN_VALUE;
    }

    public boolean preHandle(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler) throws Exception {
        long startTime = System.currentTimeMillis();
        String user = this.obtainUsername();
        logger.info("{} \u5f00\u59cb\u8bf7\u6c42 {}", (Object)user, (Object)request.getRequestURI());
        request.setAttribute("cloudt-requestStartTime", (Object)startTime);
        request.setAttribute("cloudt-requestUser", (Object)user);
        if (handler instanceof HandlerMethod) {
            this.setBusinessObjectAttribute(request, (HandlerMethod)handler);
        }
        CloudtRequestContextHolder.setRequestAttributes(null);
        ExecutorContextHolder.Source source = StringUtils.hasText((String)request.getHeader("cloudt_traceId")) ? ExecutorContextHolder.Source.WEB_RPC : ExecutorContextHolder.Source.WEB;
        ExecutorContextHolder.create((ExecutorContextHolder.Source)source, null, (boolean)false);
        return true;
    }

    public boolean supports(@NonNull MethodParameter methodParameter, @NonNull Type targetType, @NonNull Class<? extends HttpMessageConverter<?>> converterType) {
        return true;
    }

    @NonNull
    public HttpInputMessage beforeBodyRead(@NonNull HttpInputMessage inputMessage, @NonNull MethodParameter parameter, @NonNull Type targetType, @NonNull Class<? extends HttpMessageConverter<?>> converterType) throws IOException {
        return inputMessage;
    }

    @NonNull
    public Object afterBodyRead(@NonNull Object body, @NonNull HttpInputMessage inputMessage, @NonNull MethodParameter parameter, @NonNull Type targetType, @NonNull Class<? extends HttpMessageConverter<?>> converterType) {
        HttpServletRequest request = HttpServletUtil.currentRequest();
        if (request != null) {
            request.setAttribute("cloudt-requestBody", body);
        }
        return body;
    }

    public Object handleEmptyBody(Object body, @NonNull HttpInputMessage inputMessage, @NonNull MethodParameter parameter, @NonNull Type targetType, @NonNull Class<? extends HttpMessageConverter<?>> converterType) {
        return body;
    }

    public void afterCompletion(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler, Exception ex) throws Exception {
        Long startTime = (Long)request.getAttribute("cloudt-requestStartTime");
        String user = (String)request.getAttribute("cloudt-requestUser");
        Long endTime = System.currentTimeMillis();
        if (startTime != null) {
            logger.info("{} \u8bf7\u6c42 {} \u7ed3\u675f, \u8017\u65f6\uff1a{}ms", new Object[]{user, request.getRequestURI(), endTime - startTime});
        }
        CloudtRequestContextHolder.clear();
        ExecutorContextHolder.clear();
    }

    private void setBusinessObjectAttribute(HttpServletRequest request, HandlerMethod handlerMethod) {
        BusinessObject businessObject;
        BusinessObjectOperation businessObjectOperation = (BusinessObjectOperation)handlerMethod.getMethodAnnotation(BusinessObjectOperation.class);
        if (businessObjectOperation != null) {
            request.setAttribute("cloudt-businessObject-operation", (Object)businessObjectOperation);
        }
        if ((businessObject = handlerMethod.getBeanType().getAnnotation(BusinessObject.class)) == null) {
            return;
        }
        request.setAttribute("cloudt-businessObject", (Object)businessObject);
    }

    private String obtainUsername() {
        if (this.currentUserProvider == null && SpringContextHolder.initialized()) {
            this.currentUserProvider = (CurrentUserProvider)SpringContextHolder.getBean(CurrentUserProvider.class);
        }
        SysUserDTO user = this.currentUserProvider == null ? null : this.currentUserProvider.currentUser();
        return user == null ? "anonymous" : user.getUsername();
    }
}

