/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.web.config;

import com.elitescloud.boot.util.RestTemplateFactory;
import com.elitescloud.boot.web.common.signature.ApiSignatureContentProvider;
import com.elitescloud.boot.web.common.signature.ApiSignatureParamProvider;
import com.elitescloud.boot.web.common.signature.ApiSignatureProvider;
import com.elitescloud.boot.web.common.signature.ApiVerifySignatureContentProvider;
import com.elitescloud.boot.web.common.support.ApiSignatureClientHttpRequestInterceptor;
import com.elitescloud.boot.web.common.support.DefaultApiSignatureContentProvider;
import com.elitescloud.boot.web.common.support.DefaultApiSignatureParamProvider;
import com.elitescloud.boot.web.common.support.DefaultApiSignatureProvider;
import com.elitescloud.boot.web.common.support.DefaultApiVerifySignatureContentProvider;
import com.elitescloud.boot.web.config.WebProperties;
import com.elitescloud.boot.web.config.filter.ApiSignatureInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.web.client.RestTemplate;

@ConditionalOnProperty(prefix="elitesland.web.api-sign", name={"enabled"}, havingValue="true")
public class CloudtApiSignatureAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(CloudtApiSignatureAutoConfiguration.class);
    private final WebProperties webProperties;

    public CloudtApiSignatureAutoConfiguration(WebProperties webProperties) {
        this.webProperties = webProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public ApiSignatureParamProvider defaultApiSignatureParamProvider() {
        return new DefaultApiSignatureParamProvider(this.webProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    public ApiSignatureContentProvider defaultApiSignatureContentProvider() {
        return new DefaultApiSignatureContentProvider();
    }

    @Bean
    @ConditionalOnMissingBean
    public ApiVerifySignatureContentProvider apiVerifySignatureContentProvider() {
        return new DefaultApiVerifySignatureContentProvider();
    }

    @Bean
    @ConditionalOnMissingBean
    public ApiSignatureProvider apiSignatureProvider(ApiSignatureParamProvider signatureParamProvider, ApiSignatureContentProvider signatureContentProvider, ApiVerifySignatureContentProvider verifySignatureContentProvider) {
        return new DefaultApiSignatureProvider(this.webProperties, signatureParamProvider, signatureContentProvider, verifySignatureContentProvider);
    }

    @Bean(value={"restTemplateCloudtSignable"})
    public RestTemplate restTemplateCloudtSignable(ApiSignatureProvider apiSignatureProvider) {
        ApiSignatureClientHttpRequestInterceptor signatureInterceptor = new ApiSignatureClientHttpRequestInterceptor(this.webProperties, apiSignatureProvider);
        return RestTemplateFactory.instance(builder -> builder.additionalInterceptors(new ClientHttpRequestInterceptor[]{signatureInterceptor}));
    }

    @Bean
    public ApiSignatureInterceptor apiSignatureInterceptor(ApiSignatureProvider apiSignatureProvider) {
        logger.info("\u542f\u7528\u63a5\u53e3\u9a8c\u7b7e");
        return new ApiSignatureInterceptor(this.webProperties, apiSignatureProvider);
    }
}

