/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.web.config;

import com.elitescloud.boot.web.config.AbstractCustomWebConfig;
import com.elitescloud.boot.web.config.WebProperties;
import com.elitescloud.boot.web.config.filter.CloudtRequestWrapperFilter;
import com.elitescloud.boot.web.config.filter.WebRequestCommonFilter;
import com.elitescloud.boot.web.config.trace.ServletWebLogTraceHandler;
import java.util.List;
import java.util.Set;
import javax.servlet.Filter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;

@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class CustomServletWebConfig
extends AbstractCustomWebConfig {
    private static final Logger log = LogManager.getLogger(CustomServletWebConfig.class);
    private final WebProperties webProperties;

    public CustomServletWebConfig(WebProperties webProperties) {
        this.webProperties = webProperties;
    }

    @Bean
    public FilterRegistrationBean<ServletWebLogTraceHandler> logMdcFilterFilterRegistrationBean() {
        log.info("add ServletWebLogTraceHandler");
        FilterRegistrationBean registrationBean = new FilterRegistrationBean((Filter)new ServletWebLogTraceHandler(this.applicationName), new ServletRegistrationBean[0]);
        registrationBean.setUrlPatterns(List.of("/*"));
        registrationBean.setOrder(Integer.MIN_VALUE);
        return registrationBean;
    }

    @Bean
    public FilterRegistrationBean<WebRequestCommonFilter> commonFilterFilterRegistrationBean() {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        registrationBean.setFilter((Filter)new WebRequestCommonFilter(this.webProperties));
        registrationBean.setUrlPatterns(Set.of("/*"));
        registrationBean.setOrder(Integer.MAX_VALUE);
        return registrationBean;
    }

    @Bean
    @ConditionalOnProperty(prefix="elitesland.web.wrap-request", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public FilterRegistrationBean<CloudtRequestWrapperFilter> requestWrapperFilterFilterRegistrationBean() {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean((Filter)new CloudtRequestWrapperFilter(this.webProperties.getWrapRequest()), new ServletRegistrationBean[0]);
        registrationBean.setOrder(-1);
        registrationBean.addUrlPatterns(new String[]{"/*"});
        return registrationBean;
    }
}

