/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.web.config.support;

import cn.hutool.core.text.CharSequenceUtil;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.lang.NonNull;

public class EnumConverterFactory
implements ConverterFactory<String, Enum<?>> {
    public <T extends Enum<?>> Converter<String, T> getConverter(Class<T> targetType) {
        return new CustomEnumConverter(targetType);
    }

    static class CustomEnumConverter<T extends Enum<T>>
    implements Converter<String, T> {
        private final Class<T> enumType;

        public CustomEnumConverter(Class<?> enumType) {
            this.enumType = enumType;
        }

        public T convert(@NonNull String source) {
            if (CharSequenceUtil.isBlank((CharSequence)source)) {
                return null;
            }
            try {
                return Enum.valueOf(this.enumType, source.trim());
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unsupported enumeration values: " + source);
            }
        }
    }
}

