/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.web.config;

import com.elitescloud.boot.common.constant.EncryptAlgorithm;
import com.elitescloud.boot.common.constant.EncryptFormatType;
import com.elitescloud.boot.common.constant.SignatureAlgorithm;
import com.elitescloud.boot.web.common.WebHeaderRepeatKeyGenerator;
import com.elitescloud.boot.web.common.param.ApiSignatureParamIn;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@ConfigurationProperties(prefix="elitesland.web")
public class WebProperties {
    public static final String CONFIG_PREFIX = "elitesland.web";
    private String detectDomainHeader;
    @NestedConfigurationProperty
    private WrapRequest wrapRequest = new WrapRequest();
    @NestedConfigurationProperty
    private RepeatRequest repeatRequest = new RepeatRequest();
    @NestedConfigurationProperty
    private Response response = new Response();
    @NestedConfigurationProperty
    private ApiSign apiSign = new ApiSign();

    public String getDetectDomainHeader() {
        return this.detectDomainHeader;
    }

    public void setDetectDomainHeader(String detectDomainHeader) {
        this.detectDomainHeader = detectDomainHeader;
    }

    public WrapRequest getWrapRequest() {
        return this.wrapRequest;
    }

    public void setWrapRequest(WrapRequest wrapRequest) {
        this.wrapRequest = wrapRequest;
    }

    public RepeatRequest getRepeatRequest() {
        return this.repeatRequest;
    }

    public void setRepeatRequest(RepeatRequest repeatRequest) {
        this.repeatRequest = repeatRequest;
    }

    public Response getResponse() {
        return this.response;
    }

    public void setResponse(Response response) {
        this.response = response;
    }

    public ApiSign getApiSign() {
        return this.apiSign;
    }

    public void setApiSign(ApiSign apiSign) {
        this.apiSign = apiSign;
    }

    public static class WrapRequest {
        private boolean enabled = true;
        private boolean supportMultipart = false;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean getSupportMultipart() {
            return this.supportMultipart;
        }

        public void setSupportMultipart(boolean supportMultipart) {
            this.supportMultipart = supportMultipart;
        }
    }

    public static class RepeatRequest {
        private boolean enabled = false;
        private RepeatInterceptStrategy strategy = RepeatInterceptStrategy.AUTO;
        private String keyGenerator = WebHeaderRepeatKeyGenerator.class.getName();
        private boolean allowKeyEmpty = true;
        private int intervalMillis = 1000;
        private boolean useConfigForce = false;
        private int responseCode = 429;
        private int responseHttpStatus = 429;
        private String responseMsg = "\u91cd\u590d\u8bf7\u6c42";

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public RepeatInterceptStrategy getStrategy() {
            return this.strategy;
        }

        public void setStrategy(RepeatInterceptStrategy strategy) {
            this.strategy = strategy;
        }

        public String getKeyGenerator() {
            return this.keyGenerator;
        }

        public void setKeyGenerator(String keyGenerator) {
            this.keyGenerator = keyGenerator;
        }

        public boolean isAllowKeyEmpty() {
            return this.allowKeyEmpty;
        }

        public void setAllowKeyEmpty(boolean allowKeyEmpty) {
            this.allowKeyEmpty = allowKeyEmpty;
        }

        public int getIntervalMillis() {
            return this.intervalMillis;
        }

        public void setIntervalMillis(int intervalMillis) {
            this.intervalMillis = intervalMillis;
        }

        public boolean isUseConfigForce() {
            return this.useConfigForce;
        }

        public void setUseConfigForce(boolean useConfigForce) {
            this.useConfigForce = useConfigForce;
        }

        public int getResponseCode() {
            return this.responseCode;
        }

        public void setResponseCode(int responseCode) {
            this.responseCode = responseCode;
        }

        public int getResponseHttpStatus() {
            return this.responseHttpStatus;
        }

        public void setResponseHttpStatus(int responseHttpStatus) {
            this.responseHttpStatus = responseHttpStatus;
        }

        public String getResponseMsg() {
            return this.responseMsg;
        }

        public void setResponseMsg(String responseMsg) {
            this.responseMsg = responseMsg;
        }
    }

    public static class Response {
        private Map<String, String> mdcMapping = Map.of("X-Cloudt-TraceId", "cloudt_traceId");

        public Map<String, String> getMdcMapping() {
            return this.mdcMapping;
        }

        public void setMdcMapping(Map<String, String> mdcMapping) {
            this.mdcMapping = mdcMapping;
        }
    }

    public static class ApiSign {
        private boolean enabled = false;
        private String appId = "public";
        private EncryptAlgorithm encryptAlgorithm = EncryptAlgorithm.RSA;
        private EncryptFormatType encryptFormatType = EncryptFormatType.PKCS8;
        private SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.SHA256withRSA;
        private ApiSignatureParamIn signatureParamIn = ApiSignatureParamIn.HEADER;
        private String signatureParamName = "X-Cloudt-Sign";
        private String signatureTimestampParamName = "X-Cloudt-SignTime";
        private String signatureRandomParamName = "X-Cloudt-SignRandom";
        private String publicKey;
        private String privateKey;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getAppId() {
            return this.appId;
        }

        public void setAppId(String appId) {
            this.appId = appId;
        }

        public EncryptAlgorithm getEncryptAlgorithm() {
            return this.encryptAlgorithm;
        }

        public void setEncryptAlgorithm(EncryptAlgorithm encryptAlgorithm) {
            this.encryptAlgorithm = encryptAlgorithm;
        }

        public EncryptFormatType getEncryptFormatType() {
            return this.encryptFormatType;
        }

        public void setEncryptFormatType(EncryptFormatType encryptFormatType) {
            this.encryptFormatType = encryptFormatType;
        }

        public SignatureAlgorithm getSignatureAlgorithm() {
            return this.signatureAlgorithm;
        }

        public void setSignatureAlgorithm(SignatureAlgorithm signatureAlgorithm) {
            this.signatureAlgorithm = signatureAlgorithm;
        }

        public ApiSignatureParamIn getSignatureParamIn() {
            return this.signatureParamIn;
        }

        public void setSignatureParamIn(ApiSignatureParamIn signatureParamIn) {
            this.signatureParamIn = signatureParamIn;
        }

        public String getSignatureParamName() {
            return this.signatureParamName;
        }

        public void setSignatureParamName(String signatureParamName) {
            this.signatureParamName = signatureParamName;
        }

        public String getSignatureTimestampParamName() {
            return this.signatureTimestampParamName;
        }

        public void setSignatureTimestampParamName(String signatureTimestampParamName) {
            this.signatureTimestampParamName = signatureTimestampParamName;
        }

        public String getSignatureRandomParamName() {
            return this.signatureRandomParamName;
        }

        public void setSignatureRandomParamName(String signatureRandomParamName) {
            this.signatureRandomParamName = signatureRandomParamName;
        }

        public String getPublicKey() {
            return this.publicKey;
        }

        public void setPublicKey(String publicKey) {
            this.publicKey = publicKey;
        }

        public String getPrivateKey() {
            return this.privateKey;
        }

        public void setPrivateKey(String privateKey) {
            this.privateKey = privateKey;
        }
    }

    public static enum RepeatInterceptStrategy {
        NEVER,
        AUTO,
        ALWAYS;

    }
}

